/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq;

import com.vcarecity.savedb.BatchSaveDB;
import com.vcarecity.savedb.cache.DataCache;
import com.vcarecity.savedb.mq.ActiveMQReader;
import com.vcarecity.savedb.mq.MQManager;
import com.vcarecity.savedb.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.log4j.Logger;

public class DefaultActiveMQReader
implements ActiveMQReader {
    private String name;
    private String queueName;
    private int queueType;
    private BatchSaveDB batchSave;
    private DataCache cache;
    private Session session;
    private Destination queue;
    private MessageConsumer consumer;
    private Logger logger_debug = Logger.getLogger((String)"nameDebug");
    private int batch_count = 0;
    private long startTime = System.currentTimeMillis();
    private long endTime = System.currentTimeMillis();

    public DefaultActiveMQReader(String name) {
        this.name = name;
    }

    @Override
    public void setDataCache(DataCache cache) {
        this.cache = cache;
    }

    @Override
    public DataCache getDataCache() {
        return this.cache;
    }

    @Override
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void setQueueType(int queueType) {
        this.queueType = queueType;
    }

    @Override
    public int getQueueType() {
        return this.queueType;
    }

    @Override
    public void setBatchSave(BatchSaveDB batchSave) {
        this.batchSave = batchSave;
    }

    @Override
    public BatchSaveDB getBatchSave() {
        return this.batchSave;
    }

    @Override
    public void init() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("[" + sdf.format(new Date()) + "] DefaultActiveMQReader init " + this.name + " start");
        Connection connection = MQManager.openConnection();
        connection.start();
        this.session = connection.createSession(true, 1);
        this.queue = this.queueType == 1 ? this.session.createQueue(this.queueName) : this.session.createTopic(this.queueName);
        this.consumer = this.session.createConsumer(this.queue);
        System.out.println("[" + sdf.format(new Date()) + "] DefaultActiveMQReader init " + this.name + " end");
    }

    @Override
    public void startRead() {
        try {
            this.consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message msg) {
                    try {
                        if (ObjectMessage.class.isInstance(msg)) {
                            if (StringUtils.isNotBlank(String.valueOf(msg))) {
                                ObjectMessage objMsg = (ObjectMessage)msg;
                                DefaultActiveMQReader.this.cache.addData(objMsg.getObject());
                            } else {
                                System.out.println("DefaultActiveMQReader \u63a5\u6536\u5230\u6709\u6d88\u606f\u662f:" + msg);
                                DefaultActiveMQReader.this.logger_debug.info((Object)("DefaultActiveMQReader \u63a5\u6536\u5230\u6709\u6d88\u606f\u662f:" + msg));
                            }
                        } else if (DefaultActiveMQReader.this.logger_debug.isDebugEnabled()) {
                            DefaultActiveMQReader.this.logger_debug.debug((Object)("DefaultActiveMQReader msg type error:" + msg.getClass()));
                        }
                        DefaultActiveMQReader defaultActiveMQReader = DefaultActiveMQReader.this;
                        defaultActiveMQReader.batch_count = defaultActiveMQReader.batch_count + 1;
                        if (DefaultActiveMQReader.this.batch_count >= MQManager.BATCH_SIZE_READ) {
                            DefaultActiveMQReader.this.session.commit();
                            DefaultActiveMQReader.this.batch_count = 0;
                        }
                        DefaultActiveMQReader.this.endTime = System.currentTimeMillis();
                        if (DefaultActiveMQReader.this.endTime - DefaultActiveMQReader.this.startTime > (long)MQManager.READ_COMMIT_INTERVAL) {
                            DefaultActiveMQReader.this.session.commit();
                            DefaultActiveMQReader.this.batch_count = 0;
                            DefaultActiveMQReader.this.startTime = DefaultActiveMQReader.this.endTime;
                        }
                    }
                    catch (Throwable e) {
                        DefaultActiveMQReader.this.batchSave.exceptionCaught(e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.batchSave.exceptionCaught(e);
        }
    }
}

