/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq;

import com.vcarecity.savedb.mq.MQItem;
import com.vcarecity.savedb.mq.MQManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import net.sf.json.JSONObject;

public class DefaultActiveMQWriter
extends Thread {
    private String name;
    private boolean enabled = true;
    private String queueName;
    private int queueType;
    private List<MQItem> dataList = new ArrayList<MQItem>();
    private Object dataLock = new Object();
    private Session session;
    private Destination queue;
    private MessageProducer producer;
    private long throwCount = 0L;
    private List<MQItem> tempdata;
    private int writeIndex;
    private int position;
    private long loop;

    public DefaultActiveMQWriter(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<MQItem> getDataList() {
        return this.dataList;
    }

    public Object getDataLock() {
        return this.dataLock;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueType(int queueType) {
        this.queueType = queueType;
    }

    public int getQueueType() {
        return this.queueType;
    }

    public void init() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("[" + sdf.format(new Date()) + "] DefaultActiveMQWriter init " + this.name + " start");
        Connection connection = MQManager.openConnection();
        connection.start();
        this.session = connection.createSession(true, 1);
        this.queue = this.queueType == 1 ? this.session.createQueue(this.queueName) : this.session.createTopic(this.queueName);
        this.producer = this.session.createProducer(this.queue);
        System.out.println("[" + sdf.format(new Date()) + "] DefaultActiveMQWriter init " + this.name + " end");
    }

    private void addMQItem(Object data, String queueName) {
        MQItem item = new MQItem();
        item.setQueueName(queueName);
        item.setData(data);
        this.addData(item);
    }

    public long getThrowCount() {
        return this.throwCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(MQItem item) {
        if (this.dataList.size() > MQManager.MAX_CACHE_SIZE_WRITE) {
            ++this.throwCount;
            return;
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.dataList.add(item);
            this.dataLock.notifyAll();
        }
    }

    private void exceptionCaught(Throwable e) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(bos));
    }

    private Message createMessage(MQItem item, Session session) throws JMSException {
        Object obj_data = item.getData();
        ObjectMessage msg = session.createObjectMessage();
        if (JSONObject.class.isInstance(obj_data)) {
            msg.setObject((Serializable)((JSONObject)obj_data));
        } else {
            System.out.println("obj_data.getClass():" + obj_data.getClass());
            System.out.println("obj_data:" + obj_data);
        }
        return msg;
    }

    public long getLoop() {
        return this.loop;
    }

    public List<MQItem> getTempData() {
        return this.tempdata;
    }

    public int getWriteIndex() {
        return this.writeIndex;
    }

    public int getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                block8: while (true) {
                    Object object = this.dataLock;
                    synchronized (object) {
                        while (true) {
                            if (this.dataList.size() != 0) {
                                ++this.loop;
                                this.tempdata = this.dataList;
                                this.dataList = new ArrayList<MQItem>();
                                this.dataLock.notifyAll();
                                break;
                            }
                            try {
                                this.dataLock.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    this.position = 3;
                    int count = 0;
                    this.writeIndex = 0;
                    while (true) {
                        if (this.writeIndex >= this.tempdata.size()) {
                            this.tempdata.clear();
                            this.position = 4;
                            if (count > 0) {
                                this.session.commit();
                            }
                            this.position = 5;
                            continue block8;
                        }
                        MQItem item = this.tempdata.get(this.writeIndex);
                        Message msg = this.createMessage(item, this.session);
                        if (msg != null) {
                            this.producer.send(msg);
                            if (++count >= MQManager.BATCH_SIZE_WRITE) {
                                this.session.commit();
                                count = 0;
                            }
                        }
                        ++this.writeIndex;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.exceptionCaught(e);
                continue;
            }
            break;
        }
    }
}

