/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq.test;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import net.sf.json.JSONObject;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

public class JmsReceiver
implements MessageListener {
    private String USER = ActiveMQConnection.DEFAULT_USER;
    private String PASSWORD = ActiveMQConnection.DEFAULT_PASSWORD;
    private String URL = "failover://tcp://localhost:61616";
    private String queueName = "ActiveMQ.Demo";
    private Destination dest = null;
    private Connection conn = null;
    private Session session = null;
    private MessageConsumer consumer = null;
    private boolean stop = false;

    private void initialize() throws JMSException, Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.USER, this.PASSWORD, this.URL);
        this.conn = connectionFactory.createConnection();
        this.session = this.conn.createSession(false, 1);
        this.dest = this.session.createQueue(this.queueName);
        this.consumer = this.session.createConsumer(this.dest);
    }

    public void receiveMessage() throws JMSException, Exception {
        this.initialize();
        this.conn.start();
        this.consumer.setMessageListener((MessageListener)this);
        while (!this.stop) {
            Thread.sleep(50000L);
        }
    }

    public void onMessage(Message msg) {
        try {
            if (msg instanceof TextMessage) {
                TextMessage message = (TextMessage)msg;
                System.out.println("------Received TextMessage------");
                System.out.println(message.getText());
            } else if (msg instanceof MapMessage) {
                MapMessage message = (MapMessage)msg;
                System.out.println("------Received MapMessage------");
                System.out.println(message.getLong("long"));
                System.out.println(message.getBoolean("boolean"));
                System.out.println(message.getShort("short"));
                System.out.println(message.getString("MapMessage"));
                System.out.println("------Received MapMessage for while------");
                Enumeration enumer = message.getMapNames();
                while (enumer.hasMoreElements()) {
                    Object obj = enumer.nextElement();
                    System.out.println(message.getObject(obj.toString()));
                }
            } else if (msg instanceof StreamMessage) {
                StreamMessage message = (StreamMessage)msg;
                System.out.println("------Received StreamMessage------");
                System.out.println(message.readString());
                System.out.println(message.readBoolean());
                System.out.println(message.readLong());
            } else if (msg instanceof ObjectMessage) {
                System.out.println("------Received ObjectMessage------");
                ObjectMessage message = (ObjectMessage)msg;
                JSONObject jsonObject = (JSONObject)message.getObject();
                System.out.println("jsonObject1\uff1a" + jsonObject);
                System.out.println("UserName\uff1a" + jsonObject.getString("UserName"));
                System.out.println("age\uff1a" + jsonObject.getString("age"));
                System.out.println("workIn\uff1a" + jsonObject.getString("workIn"));
            } else if (msg instanceof BytesMessage) {
                System.out.println("------Received BytesMessage------");
                BytesMessage message = (BytesMessage)msg;
                byte[] byteContent = new byte[1024];
                int length = -1;
                StringBuffer content = new StringBuffer();
                while ((length = message.readBytes(byteContent)) != -1) {
                    content.append(new String(byteContent, 0, length));
                }
                System.out.println(content.toString());
            } else {
                System.out.println(msg);
            }
            this.stop = true;
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void close() throws JMSException {
        System.out.println("Consumer:->Closing connection");
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }
}

