/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq.test;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import net.sf.json.JSONObject;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

public class JmsSender {
    private String USER = ActiveMQConnection.DEFAULT_USER;
    private String PASSWORD = ActiveMQConnection.DEFAULT_PASSWORD;
    private String URL = "failover://tcp://localhost:61616";
    private String queueName = "ActiveMQ.Demo";
    private Destination destination = null;
    private Connection conn = null;
    private Session session = null;
    private MessageProducer producer = null;

    private void initialize() throws JMSException, Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.USER, this.PASSWORD, this.URL);
        this.conn = connectionFactory.createConnection();
        this.session = this.conn.createSession(false, 1);
        this.destination = this.session.createQueue(this.queueName);
        this.producer = this.session.createProducer(this.destination);
        this.producer.setDeliveryMode(1);
    }

    public void sendMessage(String msgType) throws JMSException, Exception {
        TextMessage msg;
        this.initialize();
        this.conn.start();
        if ("text".equals(msgType)) {
            String textMsg = "ActiveMQ Text Message!";
            msg = this.session.createTextMessage();
            msg.setText(textMsg);
            this.producer.send((Message)msg);
        }
        if ("map".equals(msgType)) {
            MapMessage msg2 = this.session.createMapMessage();
            msg2.setBoolean("boolean", true);
            msg2.setShort("short", (short)0);
            msg2.setLong("long", 123456L);
            msg2.setString("MapMessage", "ActiveMQ Map Message!");
            this.producer.send((Message)msg2);
        }
        if ("stream".equals(msgType)) {
            String streamValue = "ActiveMQ stream Message!";
            msg = this.session.createStreamMessage();
            msg.writeString(streamValue);
            msg.writeBoolean(false);
            msg.writeLong(1234567890L);
            this.producer.send((Message)msg);
        }
        if ("object".equals(msgType)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"UserName", (Object)"ZHULI");
            jsonObject.put((Object)"age", (Object)"30");
            jsonObject.put((Object)"workIn", (Object)"ALI");
            System.out.println("jsonObject1\uff1a" + jsonObject);
            msg = this.session.createObjectMessage();
            msg.setObject((Serializable)jsonObject);
            this.producer.send((Message)msg);
        }
        if ("bytes".equals(msgType)) {
            String byteValue = "\u5b57\u8282\u6d88\u606f";
            msg = this.session.createBytesMessage();
            msg.writeBytes(byteValue.getBytes());
            this.producer.send((Message)msg);
        }
    }

    public void close() throws JMSException {
        if (this.producer != null) {
            this.producer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }
}

