/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq.test;

import com.vcarecity.savedb.database.Unit;
import com.vcarecity.savedb.log.LogManager;
import com.vcarecity.savedb.util.PropertiesUtils;
import com.vcarecity.savedb.util.TimeUtil;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

public class MsgSender {
    private String USER = ActiveMQConnection.DEFAULT_USER;
    private String PASSWORD = ActiveMQConnection.DEFAULT_PASSWORD;
    private String URL = "failover://tcp://localhost:61616";
    private String queueName = "ActiveMQ.Demo";
    private Destination destination = null;
    private Connection conn = null;
    private Session session = null;
    private MessageProducer producer = null;

    public MsgSender() throws JMSException, Exception {
        LogManager.init();
        this.initialize();
        this.conn.start();
    }

    private void initialize() throws JMSException, Exception {
        this.USER = "vcare";
        this.PASSWORD = "manager";
        this.URL = "failover:(tcp://192.168.10.112:61616)";
        this.URL = PropertiesUtils.getMqProperty("activemq_url");
        this.USER = PropertiesUtils.getMqProperty("username");
        this.PASSWORD = PropertiesUtils.getMqProperty("password");
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.USER, this.PASSWORD, this.URL);
        this.conn = connectionFactory.createConnection();
        this.session = this.conn.createSession(false, 1);
    }

    public void sendJSONStringMessage(String queueName, String JSONString) throws JMSException, Exception {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject = JSONObject.fromObject((Object)JSONString);
            ObjectMessage msg = this.session.createObjectMessage();
            msg.setObject((Serializable)jsonObject);
            this.destination = this.session.createTopic(queueName);
            this.producer = this.session.createProducer(this.destination);
            this.producer.setDeliveryMode(1);
            this.producer.send((Message)msg);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void sendJSONObjectMessage(String queueName, JSONObject JObject) throws JMSException, Exception {
        try {
            ObjectMessage msg = this.session.createObjectMessage();
            msg.setObject((Serializable)JObject);
            this.destination = this.session.createTopic(queueName);
            this.producer = this.session.createProducer(this.destination);
            this.producer.setDeliveryMode(1);
            this.producer.send((Message)msg);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void sendMessage(String queueName) throws JMSException, Exception {
        ObjectMessage msg;
        JSONObject jsonObject;
        String jsonMessage;
        if ("protocolStructure".equals(queueName)) {
            jsonMessage = "";
            jsonMessage = "{\"protocolNo\":\"2\",\"function\":[{\"functionWord\":[\"1\"],\"dti\":[{\"id\":\"1\",\"name\":\"\u6ce8\u518c\",\"dataItem\":[{\"elementName\":\"ccid\",\"description\":\"ccid\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"address\",\"description\":\"\u7ec8\u7aef\u5730\u5740\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1}]}]},{\"functionWord\":[\"4\"],\"dti\":[{\"id\":\"4\",\"name\":\"\u6c34\u538b\u8d85\u9608\u503c\u544a\u8b66\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"dataType\",\"description\":\"\u7c7b\u578b(01\u6062\u590d,02\u4e0b\u9650\uff0c03\u4e0a\u9650)\",\"elementType\":\"NUMBER\",\"elementLen\":2,\"elementPrecision\":1},{\"elementName\":\"threshold\",\"description\":\"\u9608\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"5\"],\"dti\":[{\"id\":\"5\",\"name\":\"\u6c34\u538b\u6062\u590d\u62a5\u544a\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"dataType\",\"description\":\"\u7c7b\u578b(01\u6062\u590d,02\u4e0b\u9650\uff0c03\u4e0a\u9650)\",\"elementType\":\"NUMBER\",\"elementLen\":2,\"elementPrecision\":1},{\"elementName\":\"threshold\",\"description\":\"\u9608\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"6\"],\"dti\":[{\"id\":\"6\",\"name\":\"\u7535\u6c60\u6b20\u538b\u544a\u8b66\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"voltage\",\"description\":\"\u7535\u538b\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"7\"],\"dti\":[{\"id\":\"7\",\"name\":\"\u7535\u6c60\u6b20\u538b\u6062\u590d\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"voltage\",\"description\":\"\u7535\u538b\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"8\"],\"dti\":[{\"id\":\"8\",\"name\":\"\u65ad\u7535\u544a\u8b66\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"9\"],\"dti\":[{\"id\":\"9\",\"name\":\"\u6062\u590d\u4f9b\u7535\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"10\"],\"dti\":[{\"id\":\"10\",\"name\":\"\u8bbe\u5907\u76d6\u88ab\u6253\u5f00\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"11\"],\"dti\":[{\"id\":\"11\",\"name\":\"\u8bbe\u5907\u76d6\u6062\u590d\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1}]}]},{\"functionWord\":[\"12\"],\"dti\":[{\"id\":\"12\",\"name\":\"\u8bbe\u7f6eAPN\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"apn\",\"description\":\"apn\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"13\"],\"dti\":[{\"id\":\"13\",\"name\":\"\u8bfb\u53d6APN\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"apn\",\"description\":\"apn\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"14\"],\"dti\":[{\"id\":\"14\",\"name\":\"\u8bbe\u7f6eIP\u5730\u5740\u548c\u7aef\u53e3\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"ip\",\"description\":\"\u670d\u52a1\u5668IP\u5730\u5740\",\"elementType\":\"VARCHAR2\",\"elementLen\":30,\"elementPrecision\":1},{\"elementName\":\"port\",\"description\":\"\u7aef\u53e3\u53f7\",\"elementType\":\"VARCHAR2\",\"elementLen\":30,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"15\"],\"dti\":[{\"id\":\"15\",\"name\":\"\u8bbe\u7f6e\u538b\u529b\u9608\u503c\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"thresholdTop\",\"description\":\"\u4e0a\u9650\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"thresholdLower\",\"description\":\"\u4e0b\u9650\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"16\"],\"dti\":[{\"id\":\"16\",\"name\":\"\u8bfb\u53d6\u538b\u529b\u9608\u503c\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"thresholdTop\",\"description\":\"\u4e0a\u9650\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"thresholdLower\",\"description\":\"\u4e0b\u9650\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u7ed3\u679c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"21\"],\"dti\":[{\"id\":\"21\",\"name\":\"\u8bfb\u538b\u529b\u503c\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1},{\"elementName\":\"status\",\"description\":\"\u544a\u8b66\u6807\u5fd7\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"22\"],\"dti\":[{\"id\":\"22\",\"name\":\"\u8bfb\u7535\u6c60\u7535\u538b\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"status\",\"description\":\"\u544a\u8b66\u6807\u5fd7\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"24\"],\"dti\":[{\"id\":\"24\",\"name\":\"\u5524\u9192\u65b9\u5f0f\u8bbe\u5b9a\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"timeUnit\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"25\"],\"dti\":[{\"id\":\"25\",\"name\":\"\u5bf9\u65f6\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1}]}]},{\"functionWord\":[\"26\"],\"dti\":[{\"id\":\"26\",\"name\":\"\u8bbe\u7f6e\u538b\u529b\u4e0a\u62a5\u65f6\u95f4\u95f4\u9694\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"unit\",\"description\":\"\u5355\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"time\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"27\"],\"dti\":[{\"id\":\"27\",\"name\":\"\u8bfb\u53d6\u538b\u529b\u4e0a\u62a5\u65f6\u95f4\u95f4\u9694\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"unit\",\"description\":\"\u5355\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"time\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"28\"],\"dti\":[{\"id\":\"28\",\"name\":\"\u4e3b\u52a8\u4e0a\u62a5\u538b\u529b\u503c\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"datetime\",\"description\":\"\u65f6\u95f4\",\"elementType\":\"VARCHAR2\",\"elementLen\":21,\"elementPrecision\":1},{\"elementName\":\"pression\",\"description\":\"\u6c34\u538b\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"temperature\",\"description\":\"\u6e29\u5ea6\",\"elementType\":\"NUMBER\",\"elementLen\":5,\"elementPrecision\":1},{\"elementName\":\"status\",\"description\":\"\u544a\u8b66\u6807\u5fd7\u4f4d\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"29\"],\"dti\":[{\"id\":\"29\",\"name\":\"\u91cd\u542f\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"30\"],\"dti\":[{\"id\":\"30\",\"name\":\"\u8bbe\u7f6e\u5fc3\u8df3\u95f4\u9694\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"heartbeat\",\"description\":\"\u5fc3\u8df3\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1},{\"elementName\":\"ret\",\"description\":\"\u8fd4\u56de\u503c\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"31\"],\"dti\":[{\"id\":\"31\",\"name\":\"\u8bfb\u53d6\u5fc3\u8df3\u95f4\u9694\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"heartbeat\",\"description\":\"\u5fc3\u8df3\",\"elementType\":\"NUMBER\",\"elementLen\":1,\"elementPrecision\":1}]}]},{\"functionWord\":[\"35\"],\"dti\":[{\"id\":\"35\",\"name\":\"\u4e0b\u53d1\u5347\u7ea7\u901a\u77e5\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"port\",\"description\":\"\u7aef\u53e3\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"description\":\"IP\",\"elementName\":\"\u5347\u7ea7\u670d\u52a1\u5668IP\u5730\u5740\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"username\",\"description\":\"\u7528\u6237\u540d\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"password\",\"description\":\"\u5bc6\u7801\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1},{\"elementName\":\"filename\",\"description\":\"\u5347\u7ea7\u6587\u4ef6\u540d\",\"elementType\":\"VARCHAR2\",\"elementLen\":20,\"elementPrecision\":1}]}]},{\"functionWord\":[\"36\"],\"dti\":[{\"id\":\"36\",\"name\":\"\u9000\u51fa\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1}]}]},{\"functionWord\":[\"37\"],\"dti\":[{\"id\":\"37\",\"name\":\"\u901a\u77e5\u6ce8\u9500\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1}]}]},{\"functionWord\":[\"34\"],\"dti\":[{\"id\":\"34\",\"name\":\"\u8bfb\u53d6\u8bbe\u5907\u7248\u672c\u53f7\",\"dataItem\":[{\"elementName\":\"sn\",\"description\":\"\u6d41\u6c34\u53f7\",\"elementType\":\"NUMBER\",\"elementLen\":10,\"elementPrecision\":1},{\"elementName\":\"version\",\"description\":\"\u7248\u672c\u53f7\",\"elementType\":\"VARCHAR2\",\"elementLen\":17,\"elementPrecision\":1}]}]}]}";
            try {
                jsonObject = new JSONObject();
                jsonObject = JSONObject.fromObject((Object)jsonMessage);
                msg = this.session.createObjectMessage();
                msg.setObject((Serializable)jsonObject);
                this.destination = this.session.createTopic(queueName);
                this.producer = this.session.createProducer(this.destination);
                this.producer.setDeliveryMode(1);
                this.producer.send((Message)msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if ("msg".equals(queueName)) {
            jsonMessage = "";
            jsonMessage = "{\"gatewayNo\":\"1\",\"unitNo\":\"002315110001\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"dataItems\":[{\"id\":\"1537\",\"data\":{\"desc\":\"\uff2e231\u65c1\u624b\u62a5\",\"cnt\":\"15\",\"event\":\"00\",\"acquisitionTime\":\"" + TimeUtil.getNoYearTime() + "\",\"eventType\":\"10\",\"deviceId\":\"050106\"}},{\"id\":\"1537\",\"data\":{\"desc\":\"A201\u5bbf\u820d\u70df\u611f\",\"cnt\":\"15\",\"event\":\"01\",\"acquisitionTime\":\"" + TimeUtil.getNoYearTime() + "\",\"eventType\":\"11\",\"deviceId\":\"0A0201\"}},{\"id\":\"1537\",\"data\":{\"desc\":\"A201\u5bbf\u820d\u70df\u611f\",\"cnt\":\"15\",\"event\":\"00\",\"acquisitionTime\":\"" + TimeUtil.getNoYearTime() + "\",\"eventType\":\"11\",\"deviceId\":\"0A0201\"}},{\"id\":\"1537\",\"data\":{\"desc\":\"\u4e5d\u5c42\uff2e\u533a\u58f0\u5149\",\"cnt\":\"15\",\"event\":\"00\",\"acquisitionTime\":\"" + TimeUtil.getNoYearTime() + "\",\"eventType\":\"13\",\"deviceId\":\"050483\"}}]}";
            try {
                jsonObject = new JSONObject();
                jsonObject = JSONObject.fromObject((Object)jsonMessage);
                msg = this.session.createObjectMessage();
                msg.setObject((Serializable)jsonObject);
                this.destination = this.session.createTopic(queueName);
                this.producer = this.session.createProducer(this.destination);
                this.producer.setDeliveryMode(1);
                this.producer.send((Message)msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if ("cmd".equals(queueName)) {
            jsonMessage = "{\"gatewayNo\":\"0001\",\"unitNo\":\"0001\",\"protocolNo\":\"0001\",\"functionWord\":\"010\",\"equipmentNo\":\"01212010\",\"SN\":\"000001\",\"dataItems\":[{\"id\":\"518\",\"params\":{\"APN\":\"1\",\"IP\":\"10.10.10.1\",\"PORT\":\"10000\"}},{\"id\":\"519\",\"params\":{\"APN\":\"1\",\"IP\":\"10.10.10.1\",\"PORT\":\"10000\"}},{\"id\":\"520\",\"params\":{\"APN\":\"1\",\"IP\":\"10.10.10.1\",\"PORT\":\"10000\"}}]}";
            try {
                jsonObject = new JSONObject();
                jsonObject = JSONObject.fromObject((Object)jsonMessage);
                msg = this.session.createObjectMessage();
                msg.setObject((Serializable)jsonObject);
                this.destination = this.session.createTopic(queueName);
                this.producer = this.session.createProducer(this.destination);
                this.producer.setDeliveryMode(1);
                this.producer.send((Message)msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if ("onLineCheck".equals(queueName)) {
            Unit databean = new Unit();
            JSONObject jObj = databean.getOnLineCheckData();
            msg = this.session.createObjectMessage();
            msg.setObject((Serializable)jObj);
            this.destination = this.session.createTopic(queueName);
            this.producer = this.session.createProducer(this.destination);
            this.producer.setDeliveryMode(1);
            this.producer.send((Message)msg);
        }
        if ("register".equals(queueName)) {
            jsonMessage = "{\"gatewayNo\":\"1\",\"unitNo\":\"0000000000923041\",\"protocolNo\":\"1\",\"functionWord\":\"1\",\"SN\":\"1\",\"equipmentNo\":\"0\",\"dataItems\":[{\"id\":\"1\",\"data\":{\"ccid\":\"89860050191596018909\"}}]}";
            try {
                jsonObject = new JSONObject();
                jsonObject = JSONObject.fromObject((Object)jsonMessage);
                msg = this.session.createObjectMessage();
                msg.setObject((Serializable)jsonObject);
                this.destination = this.session.createTopic(queueName);
                this.producer = this.session.createProducer(this.destination);
                this.producer.setDeliveryMode(1);
                this.producer.send((Message)msg);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() throws JMSException {
        if (this.producer != null) {
            this.producer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public static void main(String[] args) throws JMSException, Exception {
        MsgSender sender = new MsgSender();
        String JSONString = "";
        String queueName = "";
        queueName = "msg";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384516D2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"459\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"10\",\"dataContent\":\"31362F30392F32382030313A32353A343420312D393520B8D0D1CCBBF0BEAF20D2BBB2E3B4F3CCFCD1CCB8D0\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3845E6D2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"1\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"10\",\"dataContent\":\"C6F4B6AF2031362F30392F32382031343A35303A313720312D31373720CFFBC5A5CAD6B6AF20D2BBC2A5CFFBBBF0CBA8B0B4C5A5202D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"661F84E6E12C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"18\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"10\",\"dataContent\":\"31362F31302F30382031303A32323A303220352D383120CFFBC5A5B9CAD5CF20BDCCD1A7C2A5C1F9B6B034B2E3CFFBBBF0CBA8202D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A38442702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"140\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"3136C4EA3131D4C23239C8D53231CAB13236B7D620D1CCB8D02020202020200A31BBFA3031C2B731323220BBF0BEAF202031B6B02031B2E3D7FAD7FAD7FAD7FA0A0A\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3844B6B2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"5\",\"dataContent\":\"30332F30372030353A31352030392D30303820B9CAD5CFBBD6B8B420D2BBB2E332C7F8D1CCB8D0\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"661F84EEE12C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"5\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"3030322D30313320CAE4B3F6C4A3BFE920CDA8D1B6B9CAD5CF2031362D31312D33302031343A333020BCD0B2E3C9CCB3A1BEEDC1B1C3C50D0A3030322D30323320CAE4B3F6C4A3BFE920CDA8D1B6B9CAD5CF2031362D31312D33302031343A333020BCD0B2E3C9CCB3A1B7C0BBF0B7A70D0A3030322D30353620B9E2B5E7B8D0D1CC20CDA8D1B6B9CAD5CF2031362D31312D33302031343A333020BCD0B2E3C9CCB3A1D1CCB8D00D0A3030322D30373020B9E2B5E7B8D0D1CC20CDA8D1B6B9CAD5CF2031362D\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"661F849C082C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"677\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"13\",\"dataContent\":\"31312D33302032323A323220B8D0D1CCCCBDB2E2C6F720302D30332D3631201B3804B2BFCEBBB9CAD5CF20\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3844F702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"20\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"380DCAC2BCFE3AC6F7BCFEB9CAD5CF0DB1E0BAC53A303030323230380DC0E0D0CD3ABCE0B9DCCAE4C8EB0DB5D8B5E33A3130B2E3D0C5BAC5B7A70DCAB1BCE43A323031362F31322F30362031363A31320D0D\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384616D2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"8\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"10\",\"dataContent\":\"31362F31302F32312031373A33303A333720B1B8B5E7B9CAD5CF00\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384FC702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"B9CAD5CF2020202020202020202020204946432D333033302020202020B5DA31BBD8C2B7BDD3B5D8202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020204E32543837202020202020202031383A31313A313820202020323031362D31322D370D0AB9CAD5CF2020202020202020202020204946432D333033302020202020B5DA33BBD8C2B7BDD3B5D8202020202020202020202020202020202020202020202020202020202020202020202020\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3843B6B2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"434\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"16\",\"dataContent\":\"20202020202031303A34343A3239202031322C31322C32303136204E3030312020202020202020CFFBB7C0B1A8BEAF31BAC5D6F7BBFA2020202020202020202020202020CFB5CDB3B3F5CABCBBAF2020202020202020202020202020202020202020BBF0BEAFB9CAD5CFBCBAC7E5B3FD2020202020202020202020202020202000\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"444283677A3C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"5\",\"dataContent\":\"30332F30372030353A31352030392D30303820B9CAD5CFBBD6B8B4D2BBB2E332C7F8D1CCB8D000\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384256D2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"2\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"7\",\"dataContent\":\"3631362F31322F32332031303A32310A1B39D6F7B5E7B9CAD5CF0A0A\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384FC702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"B9CAD5CF202020202020202020202020B8D0D1CC28B9E2B5E729202020CCBDB2E2C6F7204C30324430313820202020202020202020202020202020202020202020202020202020BDF4BCB1CEACBBA4202020202020204E334C3244313820202020202032333A35303A323420202020323031372D312D330D0AB9CAD5CFB1A8BEAFBDE2B3FD20202020B8D0D1CC28B9E2B5E729202020CCBDB2E2C6F7204C30324430313820202020202020202020202020202020202020202020202020202020BDF4BCB1CEAC\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384FC702D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"6\",\"dataContent\":\"B1A8BEAF202020202020202020202020BBF0BEAFBCE0CAD32020202020C9CCD2B5D6D0D0C4D2BBB2E33423CAD6B6AFB1A8BEAFB0B4C5A5B1A8BEAFBCE0CAD32028C9CCD2B5D6205A6F6E6520303031202020202020204E334C314D3238202020202020383A33383A33312020202020323031372D312D350D0AC6F4B6AF202020202020202020202020BCCCB5E7C6F720202020202020C9CCD2B5D6D0D0C4D2BBB2E33141454C312D31BEEDC1B1C8ABBDB5BFD8D6C62028C9CCD2B5D6D0D0C4205A6F6E652030\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A3849D6C2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"36\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"8\",\"dataContent\":\"30312D30342030323A3033202030343530393520B5E3D0CDB8D0D1CCBBF0BEAF20\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384256C2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"3\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"7\",\"dataContent\":\"1B401B31051B361B3931372F30332F30342031333A33343A32340A3030C2A53032B2E33030B7BFBCE40AD7A1D4BAB2BF000000000AD7DFB5C00000000000000AB9CAD5CF3A30363033330AB8D0D1CC0A1B4A011B39\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"661F8443082C\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"0\",\"dataItems\":[{\"id\":\"1538\",\"data\":{\"ret\":\"0\",\"dataType\":\"1538\",\"rowCount\":\"1\",\"hostModel\":\"9\",\"dataContent\":\"BBF0BEAF2030332D30372031363A33372030393130303520202020B5E3D0CDB8D0D1CCD6C7B3C7BBE1D2C7CAD2D5B9B0E5\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"A0A384996B2D\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"1\",\"SN\":\"3542\",\"dataItems\":[{\"id\":\"1025\",\"data\":{\"ret\":\"0\",\"dataType\":\"1025\",\"dataContent\":\"AA170613122832AA0400007F48487F04380808FF0808080000020CF08482FC04848484FC8484840400\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"1EA48379372E\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"1401\",\"dataItems\":[{\"id\":\"1793\",\"data\":{\"ret\":\"0\",\"dataType\":\"1793\",\"desc\":\"\",\"cnt\":\"0\",\"dateTime\":\"170622151435\",\"event\":\"0\",\"indication\":\"73\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"83A41E31F239\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"2\",\"SN\":\"1024\",\"dataItems\":[{\"id\":\"1793\",\"data\":{\"ret\":\"0\",\"dataType\":\"1793\",\"desc\":\"\",\"cnt\":\"0\",\"dateTime\":\"170721160545\",\"event\":\"0\",\"indication\":\"0\"}}],\"enable\":\"0\"}";
        JSONString = "{\"gatewayNo\":\"1\",\"unitNo\":\"83A41E3AD0D2\",\"protocolNo\":\"1\",\"functionWord\":\"176\",\"equipmentNo\":\"0\",\"SN\":\"2304\",\"dataItems\":[{\"id\":\"720\",\"data\":{\"ret\":\"0\",\"portNo\":\"4\",\"dataType\":\"720\",\"dateTime\":\"170808173233\",\"event\":\"1\"}},{\"id\":\"720\",\"data\":{\"ret\":\"0\",\"portNo\":\"5\",\"dateTime\":\"170808173233\",\"event\":\"1\"}},{\"id\":\"720\",\"data\":{\"ret\":\"0\",\"portNo\":\"6\",\"dateTime\":\"170808173233\",\"event\":\"1\"}}],\"enable\":\"0\"}";
        sender.sendJSONStringMessage(queueName, JSONString);
        System.out.println(String.valueOf(TimeUtil.getLocalTime()) + "DTU\u4e0a\u4f20\u6570\u636e \u5b8c\u6bd5");
        sender.close();
    }
}

