/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.mq.test;

import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;

public class ProtocolStructureReceiver
implements MessageListener {
    private String USER = ActiveMQConnection.DEFAULT_USER;
    private String PASSWORD = ActiveMQConnection.DEFAULT_PASSWORD;
    private String URL = "failover://tcp://localhost:61616";
    private String queueName = "protocolStructure";
    private Destination dest = null;
    private Connection conn = null;
    private Session session = null;
    private MessageConsumer consumer = null;

    private void initialize() throws JMSException, Exception {
        this.USER = "vcare";
        this.PASSWORD = "manager";
        this.URL = "failover:(tcp://119.146.223.117:61616)";
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.USER, this.PASSWORD, this.URL);
        this.conn = connectionFactory.createConnection();
        this.session = this.conn.createSession(false, 1);
        this.dest = this.session.createQueue(this.queueName);
        this.consumer = this.session.createConsumer(this.dest);
    }

    public void receiveMessage() throws JMSException, Exception {
        this.initialize();
        this.conn.start();
        this.consumer.setMessageListener((MessageListener)this);
    }

    public void onMessage(Message msg) {
        try {
            if (msg instanceof ObjectMessage) {
                System.out.println("------Received " + this.queueName + " ObjectMessage------");
                ObjectMessage message = (ObjectMessage)msg;
                JSONObject jsonObject = (JSONObject)message.getObject();
                System.out.println("jsonObject1\uff1a" + jsonObject);
                System.out.println("protocolNo\uff1a" + jsonObject.getString("protocolNo"));
                System.out.println("function\uff1a" + jsonObject.getJSONArray("function"));
                JSONArray functionArr = jsonObject.getJSONArray("function");
                for (Object function : functionArr) {
                    JSONObject functionObj = (JSONObject)function;
                    JSONArray jsonArr = functionObj.getJSONArray("functionWord");
                    for (Object object : jsonArr) {
                        String functionWord = (String)object;
                        System.out.println("functionWord\uff1a" + functionWord);
                    }
                    JSONArray dti = functionObj.getJSONArray("dti");
                    for (Object object : dti) {
                        JSONObject obj = (JSONObject)object;
                        System.out.println("id:" + obj.get("id"));
                        System.out.println("name:" + obj.get("name"));
                        JSONArray jsonO = (JSONArray)obj.get("dataItem");
                        for (Object oo : jsonO) {
                            JSONObject ob = (JSONObject)oo;
                            Iterator obit = ob.keys();
                            while (obit.hasNext()) {
                                String obkey = (String)obit.next();
                                System.out.println(String.valueOf(obkey) + ":" + ob.get(obkey));
                            }
                        }
                    }
                }
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void close() throws JMSException {
        System.out.println("Consumer:->Closing connection");
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public static void main(String[] args) throws JMSException, Exception {
        ProtocolStructureReceiver receiver = new ProtocolStructureReceiver();
        receiver.receiveMessage();
    }
}

