/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import com.vcarecity.savedb.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DigitalTransUtil {
    private static String hexString = "0123456789ABCDEF";

    public static String StringToAsciiString(String content) {
        String result = "";
        int max = content.length();
        int i = 0;
        while (i < max) {
            char c = content.charAt(i);
            String b = Integer.toHexString(c);
            result = String.valueOf(result) + b;
            ++i;
        }
        return result;
    }

    public static String hexStringToString(String hexString, int encodeType) {
        String result = "";
        int max = hexString.length() / encodeType;
        int i = 0;
        while (i < max) {
            char c = (char)DigitalTransUtil.hexStringToAlgorism(hexString.substring(i * encodeType, (i + 1) * encodeType));
            result = String.valueOf(result) + c;
            ++i;
        }
        return result;
    }

    public static int hexStringToAlgorism(String hex) {
        hex = hex.toUpperCase();
        int max = hex.length();
        int result = 0;
        int i = max;
        while (i > 0) {
            char c = hex.charAt(i - 1);
            int algorism = 0;
            algorism = c >= '0' && c <= '9' ? c - 48 : c - 55;
            result = (int)((double)result + Math.pow(16.0, max - i) * (double)algorism);
            --i;
        }
        return result;
    }

    public static String hexStringToBinary(String hex) {
        hex = hex.toUpperCase();
        String result = "";
        int max = hex.length();
        int i = 0;
        while (i < max) {
            char c = hex.charAt(i);
            switch (c) {
                case '0': {
                    result = String.valueOf(result) + "0000";
                    break;
                }
                case '1': {
                    result = String.valueOf(result) + "0001";
                    break;
                }
                case '2': {
                    result = String.valueOf(result) + "0010";
                    break;
                }
                case '3': {
                    result = String.valueOf(result) + "0011";
                    break;
                }
                case '4': {
                    result = String.valueOf(result) + "0100";
                    break;
                }
                case '5': {
                    result = String.valueOf(result) + "0101";
                    break;
                }
                case '6': {
                    result = String.valueOf(result) + "0110";
                    break;
                }
                case '7': {
                    result = String.valueOf(result) + "0111";
                    break;
                }
                case '8': {
                    result = String.valueOf(result) + "1000";
                    break;
                }
                case '9': {
                    result = String.valueOf(result) + "1001";
                    break;
                }
                case 'A': {
                    result = String.valueOf(result) + "1010";
                    break;
                }
                case 'B': {
                    result = String.valueOf(result) + "1011";
                    break;
                }
                case 'C': {
                    result = String.valueOf(result) + "1100";
                    break;
                }
                case 'D': {
                    result = String.valueOf(result) + "1101";
                    break;
                }
                case 'E': {
                    result = String.valueOf(result) + "1110";
                    break;
                }
                case 'F': {
                    result = String.valueOf(result) + "1111";
                }
            }
            ++i;
        }
        return result;
    }

    public static String AsciiStringToString(String content) {
        String result = "";
        int length = content.length() / 2;
        int i = 0;
        while (i < length) {
            String c = content.substring(i * 2, i * 2 + 2);
            int a = DigitalTransUtil.hexStringToAlgorism(c);
            char b = (char)a;
            String d = String.valueOf(b);
            result = String.valueOf(result) + d;
            ++i;
        }
        return result;
    }

    public static String algorismToHEXString(int algorism, int maxLength) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return DigitalTransUtil.patchHexString(result.toUpperCase(), maxLength);
    }

    public static String bytetoString(byte[] bytearray) {
        String result = "";
        int length = bytearray.length;
        int i = 0;
        while (i < length) {
            char temp = (char)bytearray[i];
            result = String.valueOf(result) + temp;
            ++i;
        }
        return result;
    }

    public static int binaryToAlgorism(String binary) {
        int max = binary.length();
        int result = 0;
        int i = max;
        while (i > 0) {
            char c = binary.charAt(i - 1);
            int algorism = c - 48;
            result = (int)((double)result + Math.pow(2.0, max - i) * (double)algorism);
            --i;
        }
        return result;
    }

    public static String algorismToHEXString(int algorism) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        result = result.toUpperCase();
        return result;
    }

    public static String patchHexString(String str, int maxLength) {
        String temp = "";
        int i = 0;
        while (i < maxLength - str.length()) {
            temp = "0" + temp;
            ++i;
        }
        str = (String.valueOf(temp) + str).substring(0, maxLength);
        return str;
    }

    public static int parseToInt(String s, int defaultInt, int radix) {
        int i = 0;
        try {
            i = Integer.parseInt(s, radix);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static int parseToInt(String s, int defaultInt) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static byte[] hexStringToByte(String hex) {
        int max = hex.length() / 2;
        byte[] bytes = new byte[max];
        String binarys = DigitalTransUtil.hexStringToBinary(hex);
        int i = 0;
        while (i < max) {
            bytes[i] = (byte)DigitalTransUtil.binaryToAlgorism(binarys.substring(i * 8 + 1, (i + 1) * 8));
            if (binarys.charAt(8 * i) == '1') {
                bytes[i] = (byte)(0 - bytes[i]);
            }
            ++i;
        }
        return bytes;
    }

    public static final byte[] hex2byte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = new Integer(byteint).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    public static final String byte2hex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            ++n;
        }
        return hs.toUpperCase();
    }

    public static String toHexString(String s) {
        String str = "";
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            String s4 = Integer.toHexString(ch);
            str = String.valueOf(str) + s4;
            ++i;
        }
        return str;
    }

    public static String hexStringToEncodeString(String s, String Encoding) {
        byte[] baKeyword = new byte[s.length() / 2];
        int i = 0;
        while (i < baKeyword.length) {
            try {
                baKeyword[i] = (byte)(0xFF & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        try {
            s = new String(baKeyword, Encoding);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return s;
    }

    public static String toStringHex2(String s) {
        byte[] baKeyword = new byte[s.length() / 2];
        int i = 0;
        while (i < baKeyword.length) {
            try {
                baKeyword[i] = (byte)(0xFF & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        try {
            s = new String(baKeyword, "GBK");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return s;
    }

    public static String encode(String str) {
        byte[] bytes = str.getBytes();
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            sb.append(hexString.charAt((bytes[i] & 0xF0) >> 4));
            sb.append(hexString.charAt((bytes[i] & 0xF) >> 0));
            ++i;
        }
        return sb.toString();
    }

    public static String decode(String bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length() / 2);
        int i = 0;
        while (i < bytes.length()) {
            baos.write(hexString.indexOf(bytes.charAt(i)) << 4 | hexString.indexOf(bytes.charAt(i + 1)));
            i += 2;
        }
        return new String(baos.toByteArray());
    }

    public static void printHexString(String hint, byte[] b) {
        System.out.print(hint);
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            System.out.print(String.valueOf(hex.toUpperCase()) + " ");
            ++i;
        }
        System.out.println("");
    }

    public static String Bytes2HexString(byte[] b) {
        String ret = "";
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            ret = String.valueOf(ret) + hex.toUpperCase();
            ++i;
        }
        return ret;
    }

    public static byte uniteBytes(byte src0, byte src1) {
        byte _b0 = Byte.decode("0x" + new String(new byte[]{src0}));
        _b0 = (byte)(_b0 << 4);
        byte _b1 = Byte.decode("0x" + new String(new byte[]{src1}));
        byte ret = (byte)(_b0 ^ _b1);
        return ret;
    }

    public static byte[] HexString2Bytes(String src) {
        byte[] ret = new byte[8];
        byte[] tmp = src.getBytes();
        int i = 0;
        while (i < 8) {
            ret[i] = DigitalTransUtil.uniteBytes(tmp[i * 2], tmp[i * 2 + 1]);
            ++i;
        }
        return ret;
    }

    public static String[] stringSplit(String srcStr) {
        String[] temp;
        String str = "\u6253\u5370\u673a*\u949f\u8868//\u81ea\u884c\u8f66**\u96e8\u4f1e%%\u6536\u97f3\u673a??\u7535\u8111 \u6c34\u676f \u98ce\u6247";
        str = "03/06 12:36 09-008 \u6545\u969c\u4e00\u5c422\u533a\u70df\u611f\u000b03/06 12:36 09-008 \u6545\u969c\u4e00\u5c422\u533a\u70df\u611f";
        String[] stringArray = temp = srcStr.split("%%|\\*+|\\//|\\?+|\\ +|\\\u000b+");
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            System.out.println(word);
            ++n2;
        }
        return temp;
    }

    public static String[] stringSplit(String srcStr, String pattern) {
        String[] temp;
        String str = "\u6253\u5370\u673a*\u949f\u8868//\u81ea\u884c\u8f66**\u96e8\u4f1e%%\u6536\u97f3\u673a??\u7535\u8111 \u6c34\u676f \u98ce\u6247";
        str = "03/06 12:36 09-008 \u6545\u969c\u4e00\u5c422\u533a\u70df\u611f\u000b03/06 12:36 09-008 \u6545\u969c\u4e00\u5c422\u533a\u70df\u611f";
        String[] stringArray = temp = srcStr.split(pattern);
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            System.out.println(word);
            ++n2;
        }
        return temp;
    }

    public static String replaceBlank(String str) {
        Pattern p = Pattern.compile("\r|\n|\t");
        System.out.println("before:" + str);
        Matcher m = p.matcher(str);
        String after = m.replaceAll("");
        System.out.println("after:" + after);
        return after;
    }

    public static void main(String[] args) {
        String s = "02 30 33 2F 30 37 20 30 35 3A 31 35 20 30 39 2D 30 30 38 20 B9 CA D5 CF BB D6 B8 B4 0A D2 BB B2 E3 32 C7 F8 D1 CC B8 D0 0D 02 30 33 2F 30 37 20 30 35 3A 31 35 20 30 39 2D 30 30 38 20 B9 CA D5 CF BB D6 B8 B4 0A D2 BB B2 E3 32 C7 F8 D1 CC B8 D0 0D 02 30 33 2F 30 37 20 30 35 3A 31 35 20 30 39 2D 30 30 38 20 B9 CA D5 CF BB D6 B8 B4 0A D2 BB B2 E3 32 C7 F8 D1 CC B8 D0 0D";
        s = "30332F30372030353A31352030392D30303820B9CAD5CFBBD6B8B40AD2BBB2E332C7F8D1CCB8D00D";
        String[] tmpArr = s.split("0D");
        s = "3030322D30353220B9E2B5E7B8D0D1CC20CDA8D1B6B9CAD5CF2031362D30332D33302031393A343120BCD0B2E3C9CCB3A1D1CCB8D00D";
        String tmp = DigitalTransUtil.hexStringToEncodeString(s.trim(), "GBK");
        System.out.println("tmp:" + DigitalTransUtil.replaceBlank(tmp));
        StringUtils.dealData(DigitalTransUtil.replaceBlank(tmp), "\\d{2}/\\d{2} \\d{2}:\\d{2}|\\d{2}/\\d{2}\\d{2}:\\d{2}|\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}", "\\d{2}-\\d{3}|[\u4e00-\u9fa5]{2}\\d{2}-\\d{1}", "MM/DD", "HH:MI");
        System.out.println("=================");
    }
}

