/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class HttpRequestUtil {
    private static HttpRequestUtil httpRequest;
    private static String url;

    public static HttpRequestUtil getHttpRequest() {
        try {
            if (httpRequest == null) {
                httpRequest = new HttpRequestUtil();
            }
        }
        catch (Exception e) {
            System.out.println("\u521b\u5efa\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25:" + e.toString());
            e.printStackTrace();
        }
        return httpRequest;
    }

    protected HttpRequestUtil() {
        FileInputStream is = null;
        Properties properties = new Properties();
        String filePath = "config/HttpRequest.properties";
        try {
            try {
                is = new FileInputStream(filePath);
                properties.load(is);
                url = properties.getProperty("url", "http://127.0.0.1:8844/");
            }
            catch (IOException ex) {
                System.err.println("\u4e0d\u80fd\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6.\u8bf7\u786e\u4fddlog.properties\u5728CLASSPATH\u6307\u5b9a\u7684\u8def\u5f84\u4e2d");
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String get(String methodName, String param) {
        return HttpRequestUtil.sendGet(String.valueOf(url) + methodName, param);
    }

    public static String post(String methodName, String param) {
        return HttpRequestUtil.sendPost(String.valueOf(url) + methodName, param);
    }

    public static String sendGet(String url, String param) {
        String result = "";
        BufferedReader in = null;
        try {
            try {
                String line;
                String urlNameString = String.valueOf(url) + "?" + param;
                URL realUrl = new URL(urlNameString);
                URLConnection connection = realUrl.openConnection();
                connection.setRequestProperty("accept", "*/*");
                connection.setRequestProperty("connection", "Keep-Alive");
                connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
                connection.connect();
                Map<String, List<String>> map = connection.getHeaderFields();
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((line = in.readLine()) != null) {
                    result = String.valueOf(result) + line;
                }
            }
            catch (Exception e) {
                System.out.println("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                e.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public static String sendPost(String url, String param) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            try {
                String line;
                URL realUrl = new URL(url);
                URLConnection conn = realUrl.openConnection();
                conn.setRequestProperty("accept", "*/*");
                conn.setRequestProperty("connection", "Keep-Alive");
                conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                out = new PrintWriter(conn.getOutputStream());
                out.print(param);
                out.flush();
                in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = in.readLine()) != null) {
                    result = String.valueOf(result) + line;
                }
            }
            catch (Exception e) {
                System.out.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
                e.printStackTrace();
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static void main(String[] args) {
        HttpRequestUtil httpRequest = new HttpRequestUtil();
        String s = "";
        s = HttpRequestUtil.sendGet("http://192.168.10.112:8844/getUserStatisticsByUserId", "userId=120");
        System.out.println(s);
    }
}

