/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class Logger {
    private static Logger logger;
    private static String logPath;
    private static String eventPath;
    private static String website;
    private static String level;
    private FileWriter fwlogger = null;
    private StackTraceElement[] elements;
    private static String ClassMethodName;

    static {
        ClassMethodName = "";
    }

    protected Logger() {
        FileInputStream is = null;
        Properties properties = new Properties();
        String filePath = "config/logger.properties";
        try {
            try {
                is = new FileInputStream(filePath);
                properties.load(is);
                logPath = properties.getProperty("logPath", "./logs/");
                website = properties.getProperty("website", "");
                level = properties.getProperty("level", "");
            }
            catch (IOException ex) {
                System.err.println("\u4e0d\u80fd\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6.\u8bf7\u786e\u4fddlog.properties\u5728CLASSPATH\u6307\u5b9a\u7684\u8def\u5f84\u4e2d");
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Logger getLogger() {
        try {
            if (logger == null) {
                logger = new Logger();
            }
        }
        catch (Exception e) {
            System.out.println("\u521b\u5efa\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25:" + e.toString());
            e.printStackTrace();
        }
        return logger;
    }

    public String getLogParentPath() {
        int ss = logPath.length();
        String strPath = logPath.substring(0, ss - 1);
        ss = strPath.lastIndexOf(92);
        String retPath = strPath.substring(0, ss + 1);
        return retPath;
    }

    public void setLogPath(String path) {
        logPath = path == null ? "" : path;
    }

    public String getLevel() {
        return level;
    }

    public synchronized void writeLog(String msg) {
        StringBuffer fileName = new StringBuffer();
        if (logPath != null) {
            fileName.append(logPath);
        } else {
            System.out.println("logpath is null!");
        }
        this.elements = new Throwable().getStackTrace();
        ClassMethodName = String.valueOf(this.elements[1].getClassName()) + "." + this.elements[1].getMethodName();
        if ("".equalsIgnoreCase(website)) {
            fileName.append("Log_");
        } else {
            fileName.append("Log_" + website + "_" + ClassMethodName + "_");
        }
        Timestamp nowDate = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String aa = sdf.format(nowDate);
        fileName.append(aa);
        fileName.append(".txt");
        try {
            try {
                this.fwlogger = new FileWriter(fileName.toString(), true);
                StringBuffer sbMsg = new StringBuffer();
                sbMsg.append(String.valueOf(Logger.getLongTimeString()) + ":\r\n");
                sbMsg.append(msg);
                sbMsg.append("\r\n");
                this.fwlogger.write(sbMsg.toString());
            }
            catch (Exception e) {
                System.out.println("writer log error:" + e.toString());
                try {
                    if (this.fwlogger != null) {
                        this.fwlogger.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.fwlogger != null) {
                    this.fwlogger.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void writeErrorLog(String msg) {
        StringBuffer fileName = new StringBuffer();
        if (logPath != null) {
            fileName.append(logPath);
        } else {
            System.out.println("logpath is null!");
        }
        this.elements = new Throwable().getStackTrace();
        ClassMethodName = String.valueOf(this.elements[1].getClassName()) + "." + this.elements[1].getMethodName();
        if ("".equalsIgnoreCase(website)) {
            fileName.append("ErrorLog_");
        } else {
            fileName.append("ErrorLog_" + website + "_" + ClassMethodName + "_");
        }
        Timestamp nowDate = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String aa = sdf.format(nowDate);
        fileName.append(aa);
        fileName.append(".txt");
        try {
            try {
                this.fwlogger = new FileWriter(fileName.toString(), true);
                StringBuffer sbMsg = new StringBuffer();
                sbMsg.append(String.valueOf(Logger.getLongTimeString()) + ":\r\n");
                sbMsg.append("Error:" + msg);
                sbMsg.append("\r\n");
                this.fwlogger.write(sbMsg.toString());
            }
            catch (Exception e) {
                System.out.println("writer log error:" + e.toString());
                try {
                    if (this.fwlogger != null) {
                        this.fwlogger.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.fwlogger != null) {
                    this.fwlogger.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void writeDebugLog(String msg) {
        StringBuffer fileName = new StringBuffer();
        if (logPath != null) {
            fileName.append(logPath);
        } else {
            System.out.println("logpath is null!");
        }
        this.elements = new Throwable().getStackTrace();
        ClassMethodName = String.valueOf(this.elements[1].getClassName()) + "." + this.elements[1].getMethodName();
        if ("".equalsIgnoreCase(website)) {
            fileName.append("DebugLog_");
        } else {
            fileName.append("DebugLog_" + website + "_" + ClassMethodName + "_");
        }
        Timestamp nowDate = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String aa = sdf.format(nowDate);
        fileName.append(aa);
        fileName.append(".txt");
        try {
            try {
                this.fwlogger = new FileWriter(fileName.toString(), true);
                StringBuffer sbMsg = new StringBuffer();
                sbMsg.append(String.valueOf(Logger.getLongTimeString()) + ":\r\n");
                sbMsg.append("Debug:" + msg);
                sbMsg.append("\r\n");
                this.fwlogger.write(sbMsg.toString());
            }
            catch (Exception e) {
                System.out.println("writer log error:" + e.toString());
                try {
                    if (this.fwlogger != null) {
                        this.fwlogger.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.fwlogger != null) {
                    this.fwlogger.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void writeDebugInfo(String msg) {
        StringBuffer fileName = new StringBuffer();
        if (logPath != null) {
            fileName.append(logPath);
        } else {
            System.out.println("logpath is null!");
        }
        this.elements = new Throwable().getStackTrace();
        ClassMethodName = String.valueOf(this.elements[1].getClassName()) + "." + this.elements[1].getMethodName();
        if ("".equalsIgnoreCase(website)) {
            fileName.append("DebugInfo_");
        } else {
            fileName.append("DebugInfo_" + website + "_" + ClassMethodName + "_");
        }
        Timestamp nowDate = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String aa = sdf.format(nowDate);
        fileName.append(aa);
        fileName.append(".txt");
        try {
            try {
                this.fwlogger = new FileWriter(fileName.toString(), true);
                StringBuffer sbMsg = new StringBuffer();
                sbMsg.append(String.valueOf(Logger.getLongTimeString()) + ":\r\n");
                sbMsg.append("Debug:" + msg);
                sbMsg.append("\r\n");
                this.fwlogger.write(sbMsg.toString());
            }
            catch (Exception e) {
                System.out.println("writer log error:" + e.toString());
                try {
                    if (this.fwlogger != null) {
                        this.fwlogger.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.fwlogger != null) {
                    this.fwlogger.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getEventParentPath() {
        int ss = eventPath.length();
        String strPath = eventPath.substring(0, ss - 1);
        ss = strPath.lastIndexOf(92);
        String retPath = strPath.substring(0, ss + 1);
        return retPath;
    }

    public void setEventPath(String path) {
        eventPath = path == null ? "" : path;
    }

    public synchronized void writeEvent(String msg) {
        StringBuffer fileName = new StringBuffer();
        if (eventPath != null) {
            fileName.append(eventPath);
        } else {
            System.out.println("Eventpath is null ");
        }
        this.elements = new Throwable().getStackTrace();
        ClassMethodName = String.valueOf(this.elements[1].getClassName()) + "." + this.elements[1].getMethodName();
        if ("".equalsIgnoreCase(website)) {
            fileName.append("System_Event_");
        } else {
            fileName.append("System_Event_" + website + "_" + ClassMethodName + "_");
        }
        Timestamp nowDate = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String aa = sdf.format(nowDate);
        fileName.append(aa);
        fileName.append(".txt");
        try {
            try {
                this.fwlogger = new FileWriter(fileName.toString(), true);
                StringBuffer sbMsg = new StringBuffer();
                sbMsg.append(String.valueOf(Logger.getLongTimeString()) + ":\r\n");
                sbMsg.append(msg);
                sbMsg.append("\r\n");
                this.fwlogger.write(sbMsg.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (this.fwlogger != null) {
                        this.fwlogger.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.fwlogger != null) {
                    this.fwlogger.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void writeDebugEvent(String eventFlag, String msg) {
        StringBuffer fileName = new StringBuffer();
        if (eventPath != null) {
            fileName.append(eventPath);
        } else {
            System.out.println("Eventpath is null ");
        }
        this.elements = new Throwable().getStackTrace();
        ClassMethodName = String.valueOf(this.elements[1].getClassName()) + "." + this.elements[1].getMethodName();
        if ("".equalsIgnoreCase(website)) {
            fileName.append(String.valueOf(eventFlag) + "_");
        } else {
            fileName.append(String.valueOf(eventFlag) + "_" + website + "_" + ClassMethodName + "_");
        }
        Timestamp nowDate = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String aa = sdf.format(nowDate);
        fileName.append(aa);
        fileName.append(".txt");
        try {
            try {
                this.fwlogger = new FileWriter(fileName.toString(), true);
                StringBuffer sbMsg = new StringBuffer();
                sbMsg.append(String.valueOf(Logger.getLongTimeString()) + ":\r\n");
                sbMsg.append(msg);
                sbMsg.append("\r\n");
                this.fwlogger.write(sbMsg.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (this.fwlogger != null) {
                        this.fwlogger.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.fwlogger != null) {
                    this.fwlogger.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getEncodeString(String s) {
        String retStr = "";
        try {
            if (s != null) {
                retStr = new String(s.getBytes("ISO-8859-1"), "GBK");
            }
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(s) + " getEncodeString error:" + ex.toString());
        }
        return retStr;
    }

    public static String getLongTimeString() {
        Date myDate = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String mDate = formatter.format(myDate);
        return mDate;
    }

    public static void main(String[] args) {
        Logger log = Logger.getLogger();
        log.writeLog("111111111111111");
    }
}

