/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.util;

import com.vcarecity.savedb.util.StringUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
    public static final long MS_ONE_DAY = 86400000L;
    public static final long MS_DAY_FROM = 28800000L;

    public static long clearTime(long time) {
        return (time + 28800000L) / 86400000L * 86400000L - 28800000L;
    }

    public static java.sql.Date clearTime(java.sql.Date d) {
        return new java.sql.Date((d.getTime() + 28800000L) / 86400000L * 86400000L - 28800000L);
    }

    public static java.sql.Date getDate(java.sql.Date date, Time time) {
        return new java.sql.Date(TimeUtil.clearTime(date.getTime()) + time.getTime() + 28800000L);
    }

    public static long getDate(long date, long time) {
        return TimeUtil.clearTime(date) + time + 28800000L;
    }

    public static Timestamp getTimestamp() {
        Timestamp d = new Timestamp(System.currentTimeMillis());
        return d;
    }

    public static Timestamp getTimestamp(java.sql.Date date, Time time) {
        return new Timestamp(TimeUtil.clearTime(date.getTime()) + time.getTime() + 28800000L);
    }

    public static Timestamp getTimestamp(Timestamp stamp, Time time) {
        return new Timestamp(TimeUtil.clearTime(stamp.getTime()) + time.getTime() + 28800000L);
    }

    public static Timestamp getTimestamp(String dateStr) {
        return TimeUtil.getTimestamp(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static Timestamp getTimestamp(String dateStr, String fmt) {
        SimpleDateFormat sf = new SimpleDateFormat(fmt);
        Timestamp tm = null;
        try {
            dateStr = dateStr.replace("0A", "10");
            Date date = sf.parse(dateStr);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            tm = new Timestamp(cal.getTimeInMillis());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tm;
    }

    private static String conversion(int field) {
        String str = field < 10 ? "0" + field : String.valueOf(field);
        return str;
    }

    private static String AM_MPTime(int field, int isRest) {
        String str = isRest == 1 ? String.valueOf(field + 12) : String.valueOf(field);
        return str;
    }

    public static String getSystemTime() {
        GregorianCalendar date = new GregorianCalendar();
        StringBuffer str = new StringBuffer();
        int year = date.get(1);
        String month = TimeUtil.conversion(date.get(2) + 1);
        String day = TimeUtil.conversion(date.get(5));
        String hour = TimeUtil.AM_MPTime(date.get(10), date.get(9));
        String minute = TimeUtil.conversion(date.get(12));
        String second = TimeUtil.conversion(date.get(13));
        str.append(year);
        str.append(month);
        str.append(day);
        str.append(hour);
        str.append(minute);
        str.append(second);
        return str.toString();
    }

    public static String getLocalTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    public static String getNoYearTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        return sdf.format(new Date());
    }

    public static Timestamp getFullDateTimeString(String dateTimeString, String dataTimeFormats) {
        String[] tmpAtr = new String[]{"19990101", "010101"};
        String dateSimeStr = "";
        String regexp = "[`~!@#$%^&*()+|{}':;',\\-\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f\u5e74\u6708\u65e5\u65f6\u5206\u79d2 ]";
        Calendar a = Calendar.getInstance();
        if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}\u65f6\\d{2}\u5206".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(dateTimeString) + "00\u79d2";
        } else if ("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + dateTimeString + ":00";
        } else if ("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + dateTimeString;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + "00";
        } else if ("\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + ss;
        } else if ("\\d{2,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + "00";
        } else if ("\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + ss;
        } else if ("\\d{4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2,4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + "00";
        } else if ("\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + ss;
        } else if ("\\d{2,4}\\.\\d{1,2}.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2,4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{4}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{4}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2}\\/\\d{2}\\/\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + dateTimeString;
        } else if ("\\d{2}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}\u65f6\\d{2}\u5206".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2}\\/\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(a.get(1)) + "/" + dateTimeString + ":00";
        } else if ("\\d{2}\\/\\d{2}\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(a.get(1)) + "/" + dateTimeString + ":00";
        } else if ("\\d{2}-\\d{2}-\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + dateTimeString + ":00";
        } else if ("\\d{2}-\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            dateSimeStr = String.valueOf(a.get(1)) + "-" + dateTimeString + ":00";
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""), regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""), regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""), regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString.replaceAll(" ", ""), regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + "00";
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + "00";
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + ss;
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String m = tmpA[0];
            String d = tmpA[1];
            String h = tmpA[2];
            String s = tmpA[3];
            String ss = tmpA[4];
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(a.get(1)) + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2,4}\u5e74\\d{1,2}\u6708 \\d{1,2}\u65e5\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5 \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{4}\u5e74\\d{2}\u6708\\d{2}\u65e5 \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            y = StringUtils.leftAppendZero(y, 4);
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2}\u5e74\\d{2}\u6708\\d{2}\u65e5\\d{2}\u65f6\\d{2}\u5206".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + tmpA[0].trim();
            String m = tmpA[0].trim();
            String d = tmpA[1].trim();
            String h = tmpA[2].trim();
            String s = tmpA[3].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2}\u5e74\\d{2}\u6708\\d{2}\u65e5 \\d{2}\u65f6\\d{2}\u5206".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + tmpA[0].trim();
            String m = tmpA[0].trim();
            String d = tmpA[1].trim();
            String h = tmpA[2].trim();
            String s = tmpA[3].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6\\d{1,2}\u5206".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(a.get(1));
            String m = tmpA[0].trim();
            String d = tmpA[1].trim();
            String h = tmpA[2].trim();
            String s = tmpA[3].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + tmpA[0].trim();
            String m = tmpA[0].trim();
            String d = tmpA[1].trim();
            String h = tmpA[2].trim();
            String s = tmpA[3].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{4}\\/\\d{1,2}\\/\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2,4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = "00";
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{2}-\\d{1,2}-\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[3].trim();
            String m = tmpA[4].trim();
            String d = tmpA[5].trim();
            String h = tmpA[0].trim();
            String s = tmpA[1].trim();
            String ss = tmpA[2].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{1,2}:\\d{1,2}:\\d{1,2} \\d{4}-\\d{1,2}-\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[3].trim();
            String m = tmpA[4].trim();
            String d = tmpA[5].trim();
            String h = tmpA[0].trim();
            String s = tmpA[1].trim();
            String ss = tmpA[2].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2}\\.\\d{2}\\.\\d{2} \\d{2}:\\d{2}:\\d{2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2,4}\\.\\d{1,2}\\.\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[0].trim();
            String m = tmpA[1].trim();
            String d = tmpA[2].trim();
            String h = tmpA[3].trim();
            String s = tmpA[4].trim();
            String ss = tmpA[5].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        } else if ("\\d{2}:\\d{2}:\\d{1,2} \\d{2},\\d{2},\\d{4}".equals(dataTimeFormats)) {
            String[] tmpA = StringUtils.stringSplit(dateTimeString, regexp);
            String y = tmpA[5].trim();
            String m = tmpA[4].trim();
            String d = tmpA[3].trim();
            String h = tmpA[0].trim();
            String s = tmpA[1].trim();
            String ss = tmpA[2].trim();
            if (y.length() < 4) {
                y = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + y;
            }
            m = StringUtils.leftAppendZero(m, 2);
            d = StringUtils.leftAppendZero(d, 2);
            h = StringUtils.leftAppendZero(h, 2);
            s = StringUtils.leftAppendZero(s, 2);
            ss = StringUtils.leftAppendZero(ss, 2);
            dateSimeStr = String.valueOf(y) + m + d + h + s + ss;
        }
        dateSimeStr = StringUtils.StringFilterSpecificCharacter(regexp, dateSimeStr);
        return TimeUtil.getTimestamp(dateSimeStr, "yyyyMMddHHmmss");
    }

    public static Timestamp getFullDateTimeString(String dateTimeString, String dataFormats, String timeFormats) {
        String[] timeFormat;
        String[] dayFormats;
        String[] tmpAtr = new String[]{"19990101", "010101"};
        String dateStr = "";
        String timeStr = "";
        if (dateTimeString.indexOf(" ") > 0) {
            tmpAtr = dateTimeString.split(" ");
            dateStr = tmpAtr[0];
            timeStr = tmpAtr[1];
        } else if (dateTimeString.indexOf("\u65e5") > 0) {
            tmpAtr = dateTimeString.split("\u65e5");
            dateStr = String.valueOf(tmpAtr[0]) + "\u65e5";
            timeStr = tmpAtr[1];
        } else {
            return TimeUtil.getTimestamp("19990101010101", "yyyyMMddHHmmss");
        }
        Calendar a = Calendar.getInstance();
        String[] stringArray = dayFormats = dataFormats.split("\\|", 100);
        int n = dayFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String[] tmp;
            String d;
            String m;
            String y;
            String d2;
            String m2;
            String[] tmpA;
            String date_format = stringArray[n2];
            if ("MMDD".equalsIgnoreCase(date_format = StringUtils.StringFilterNoColon(date_format).toString())) {
                dateStr = String.valueOf(a.get(1)) + StringUtils.StringFilter(dateStr);
            } else if ("M\u6708D\u65e5".equalsIgnoreCase(date_format)) {
                tmpA = StringUtils.stringSplit(dateStr, "-|\u6708|/");
                m2 = tmpA[0];
                m2 = StringUtils.leftAppendZero(m2, 2);
                d2 = StringUtils.removeChinese(tmpA[1]);
                d2 = StringUtils.leftAppendZero(d2, 2);
                dateStr = String.valueOf(a.get(1)) + StringUtils.StringFilter(String.valueOf(m2) + d2);
            } else if ("MM\u6708DD\u65e5".equalsIgnoreCase(date_format)) {
                tmpA = StringUtils.stringSplit(dateStr, "-|\u6708|/");
                m2 = tmpA[0];
                m2 = StringUtils.leftAppendZero(m2, 2);
                d2 = StringUtils.removeChinese(tmpA[1]);
                d2 = StringUtils.leftAppendZero(d2, 2);
                dateStr = String.valueOf(a.get(1)) + StringUtils.StringFilter(String.valueOf(m2) + d2);
            } else if ("YYMMDD".equalsIgnoreCase(date_format)) {
                dateStr = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + StringUtils.StringFilter(dateStr);
            } else if ("YY\u5e74M\u6708D\u65e5".equalsIgnoreCase(date_format)) {
                tmpA = StringUtils.stringSplit(dateStr, "-|\u5e74|\u6708|\u65e5|/");
                y = tmpA[0];
                m = tmpA[1];
                d = tmpA[2];
                m = StringUtils.leftAppendZero(m, 2);
                d = StringUtils.leftAppendZero(d, 2);
                dateStr = String.valueOf(a.get(1)) + StringUtils.StringFilter(String.valueOf(y) + m + d);
            } else if ("YY\u5e74MM\u6708DD\u65e5".equalsIgnoreCase(date_format)) {
                dateStr = String.valueOf(String.valueOf(a.get(1)).substring(0, 2)) + StringUtils.StringFilterSpecificCharacter("\u5e74|\u6708|\u65e5", dateStr);
            } else if ("YYYY\u5e74M\u6708D\u65e5".equalsIgnoreCase(date_format)) {
                tmpA = StringUtils.stringSplit(dateStr, "-|\u5e74|\u6708|\u65e5|/");
                y = tmpA[0];
                m = tmpA[1];
                d = tmpA[2];
                m = StringUtils.leftAppendZero(m, 2);
                d = StringUtils.leftAppendZero(d, 2);
                dateStr = String.valueOf(a.get(1)) + StringUtils.StringFilter(String.valueOf(y) + m + d);
            } else if ("YYYY\u5e74MM\u6708DD\u65e5".equalsIgnoreCase(date_format)) {
                dateStr = StringUtils.StringFilterSpecificCharacter("\u5e74|\u6708|\u65e5", dateStr);
            } else if ("DDMM".equalsIgnoreCase(date_format)) {
                if (dateStr.replaceAll(" ", "").length() == 4) {
                    dateStr = String.valueOf(dateStr.substring(2, 4)) + dateStr.substring(0, 2);
                } else {
                    tmp = StringUtils.stringSplit(dateStr);
                    dateStr = String.valueOf(a.get(1)) + tmp[1] + tmp[0];
                }
            } else if ("YYYYMMDD".equalsIgnoreCase(date_format)) {
                dateStr = StringUtils.StringFilter(dateStr);
            } else if ("MMDDYYYY".equalsIgnoreCase(date_format.replace("/", ""))) {
                if (dateStr.replaceAll(" ", "").length() == 4) {
                    dateStr = String.valueOf(dateStr.substring(4, 8)) + dateStr.substring(0, 2) + dateStr.substring(2, 4);
                } else {
                    tmp = StringUtils.stringSplit(dateStr);
                    dateStr = String.valueOf(tmp[2]) + tmp[0] + tmp[1];
                }
            } else if ("DDMMYYYY".equalsIgnoreCase(date_format.replace("/", ""))) {
                if (dateStr.replaceAll(" ", "").length() == 4) {
                    dateStr = String.valueOf(dateStr.substring(4, 8)) + dateStr.substring(2, 4) + dateStr.substring(0, 2);
                } else {
                    tmp = StringUtils.stringSplit(dateStr);
                    dateStr = String.valueOf(tmp[2]) + tmp[1] + tmp[0];
                }
            } else if ("YYYYDDMM".equalsIgnoreCase(date_format.replace("/", ""))) {
                if (dateStr.replaceAll(" ", "").length() == 4) {
                    dateStr = String.valueOf(dateStr.substring(0, 4)) + dateStr.substring(6, 8) + dateStr.substring(4, 6);
                } else {
                    tmp = StringUtils.stringSplit(dateStr);
                    dateStr = String.valueOf(tmp[2]) + tmp[1] + tmp[0];
                }
            } else {
                dateStr = "19990101";
            }
            if (!dateStr.equals("19990101")) break;
            ++n2;
        }
        String[] stringArray2 = timeFormat = timeFormats.split("\\|", 100);
        int n3 = timeFormat.length;
        n = 0;
        while (n < n3) {
            String time_format = stringArray2[n];
            time_format = StringUtils.StringFilter(time_format).toString();
            if (timeStr.indexOf("\u65f6") > 0) {
                String regEx = "\u65f6|\u5206|\u79d2";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(timeStr);
                timeStr = m.replaceAll("").trim();
            }
            if (timeStr.indexOf(":") > 0) {
                tmpAtr = timeStr.split(":");
                timeStr = tmpAtr.length >= 3 ? String.valueOf(StringUtils.leftAppendZero(tmpAtr[0], 2)) + StringUtils.leftAppendZero(tmpAtr[1], 2) + StringUtils.leftAppendZero(tmpAtr[2], 2) : (tmpAtr.length == 2 ? String.valueOf(StringUtils.leftAppendZero(tmpAtr[0], 2)) + StringUtils.leftAppendZero(tmpAtr[1], 2) + "00" : (tmpAtr.length == 1 ? String.valueOf(StringUtils.leftAppendZero(tmpAtr[0], 2)) + StringUtils.leftAppendZero(tmpAtr[1], 2) + StringUtils.leftAppendZero(tmpAtr[2], 2) : "00:00:00"));
            }
            if (!(timeStr = "HHmm".equalsIgnoreCase(time_format) ? String.valueOf(StringUtils.StringFilter(timeStr)) + "00" : ("HHmmss".equalsIgnoreCase(time_format) ? StringUtils.StringFilter(timeStr) : ("HHmi".equalsIgnoreCase(time_format) ? String.valueOf(StringUtils.StringFilter(timeStr)) + "00" : ("HHmiss".equalsIgnoreCase(time_format) ? StringUtils.StringFilter(timeStr) : "010101")))).equals("010101")) break;
            ++n;
        }
        return TimeUtil.getTimestamp(String.valueOf(dateStr) + timeStr, "yyyyMMddHHmmss");
    }

    public static void main(String[] args) {
        String[] tmpA;
        System.out.println(TimeUtil.getTimestamp("2015-12-21 21:54:36"));
        System.out.println(TimeUtil.getTimestamp("20151221215436", "yyyyMMddHHmmss"));
        System.out.println(TimeUtil.getNoYearTime());
        System.out.println(TimeUtil.getFullDateTimeString("7\u670826\u65e516:08", "M\u6708D\u65e5|MM-DD", "HHMM"));
        GregorianCalendar date = new GregorianCalendar();
        System.out.println(date.get(1));
        String[] stringArray = tmpA = StringUtils.stringSplit("2016\u5e7412\u670828\u65e5", "-|\u5e74|\u6708|\u65e5|/");
        int n = tmpA.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println("s=" + s);
            ++n2;
        }
        double i = Double.parseDouble("0.0");
        System.out.println("i=" + i);
    }
}

