/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.web;

import com.vcarecity.savedb.BatchSaveDB;
import com.vcarecity.savedb.util.PropertiesUtils;
import com.vcarecity.savedb.web.servlet.LoadInfoServlet;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class WebServer {
    private static BatchSaveDB batchSave;

    public static void main(String[] args) {
        WebServer webServer = new WebServer();
        try {
            webServer.startService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BatchSaveDB getBatchSave() {
        return batchSave;
    }

    public static void setBatchSave(BatchSaveDB batchSave) {
        WebServer.batchSave = batchSave;
    }

    public void startService() throws Exception {
        int port = Integer.valueOf(PropertiesUtils.getWebProperty("port"));
        String resourceBase = PropertiesUtils.getWebProperty("resourceBase");
        Server server = new Server(port);
        ServletContextHandler servletHandler = new ServletContextHandler();
        servletHandler.setSessionHandler(new SessionHandler());
        servletHandler.addServlet(LoadInfoServlet.class, "/loadInfo");
        ResourceHandler resource_handler = new ResourceHandler();
        resource_handler.setDirectoriesListed(true);
        resource_handler.setWelcomeFiles(new String[]{"index.html"});
        resource_handler.setResourceBase(resourceBase);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{resource_handler, servletHandler});
        server.setHandler((Handler)handlers);
        server.start();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("web server ready![" + port + "](" + sdf.format(new Date()) + ")");
    }
}

