/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.redis.JedisUtil;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.database.CmdRecord;
import com.vcarecity.savedb.database.ConnectionManager;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.TableLocks;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.eclipse.jetty.util.StringUtil;

public class CmdResponseWriter
extends SimpleWriter {
    private static StringBuffer SQLStr = null;
    Logger log = null;
    CmdRecord cmdR = null;
    JedisUtil jedisUtil = null;

    @Override
    public void init() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("[" + sdf.format(new Date()) + "] CmdResponseWriter init " + this.name + " start");
        this.log = Logger.getLogger();
        this.cmdR = new CmdRecord();
        this.jedisUtil = JedisUtil.getInstance();
        System.out.println("[" + sdf.format(new Date()) + "] CmdResponseWriter init " + this.name + " end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        Object object = TableLocks.TABLE_LOCK;
        synchronized (object) {
            this.doSave(list);
        }
    }

    public void save2Redis(Object cmdResponse) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("cmdResponse", ((JSONObject)cmdResponse).toString());
    }

    public void doSave(List<Object> list) {
        block17: {
            Connection con = null;
            PreparedStatement pst = null;
            int batchCount = 0;
            String gatewayNo = "";
            String unitNo = "";
            String sn = "";
            String protocolNo = "";
            String functionWord = "";
            String equipmentNo = "";
            String deviceId = "";
            int pIndex = 0;
            try {
                con = ConnectionManager.openConnection();
                con.setAutoCommit(false);
                SQLStr = new StringBuffer();
                SQLStr.append("{call P_UPDATE_CMD_RECORD(?,?,?)}");
                pst = con.prepareStatement(SQLStr.toString());
                int i = 0;
                while (i < list.size()) {
                    JSONObject msg = (JSONObject)list.get(i);
                    if (msg == null) {
                        System.out.println("doSave msg==null list:" + list);
                    } else {
                        this.log.writeDebugLog("msg:" + msg.toString());
                        try {
                            StringBuffer cb = new StringBuffer();
                            cb.append("/0");
                            gatewayNo = msg.getString("gatewayNo");
                            unitNo = msg.getString("unitNo");
                            protocolNo = msg.getString("protocolNo");
                            functionWord = msg.getString("functionWord");
                            equipmentNo = msg.getString("equipmentNo");
                            sn = msg.getString("SN");
                            if (StringUtil.isNotBlank((String)unitNo)) {
                                cb.append("/" + unitNo);
                                deviceId = unitNo;
                            }
                            if (StringUtil.isNotBlank((String)equipmentNo) && !"0".equals(equipmentNo)) {
                                cb.append("/" + equipmentNo);
                                deviceId = equipmentNo;
                            }
                            JSONArray dataItems = msg.getJSONArray("dataItems");
                            for (Object object : dataItems) {
                                JSONObject dataItem = (JSONObject)object;
                                int id = Integer.valueOf(dataItem.getString("id"));
                                JSONObject data = dataItem.getJSONObject("data");
                                String ret = data.getString("ret");
                                if ("0".equals(ret) || "0.0".equals(ret)) {
                                    this.cmdR.updateCmdRecord(sn, unitNo);
                                    pIndex = 1;
                                    pst.setString(pIndex++, sn);
                                    pst.setString(pIndex++, unitNo);
                                    pst.setInt(pIndex++, 0);
                                    pst.addBatch();
                                    ++batchCount;
                                }
                                if (batchCount < this.batchSize) continue;
                                pst.executeBatch();
                                con.commit();
                                batchCount = 0;
                            }
                        }
                        catch (Exception e) {
                            this.log.writeErrorLog(msg.toString());
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                if (batchCount > 0) {
                    pst.executeBatch();
                    con.commit();
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                IOUtil.closeDB(null, pst, con);
                break block17;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.closeDB(null, pst, con);
                }
            }
            IOUtil.closeDB(null, pst, con);
        }
    }
}

