/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.DeliverBuff;
import com.vcarecity.redis.JedisUtil;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.database.ConnectionManager;
import com.vcarecity.savedb.database.DtuHistory;
import com.vcarecity.savedb.util.HexUtil;
import com.vcarecity.savedb.util.HttpRequestUtil;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.TableLocks;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.jms.JMSException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class FireHostDataWriter
extends SimpleWriter {
    private static StringBuffer SQLStr = null;
    Logger log = null;
    DtuHistory dtuHistoryBean = null;
    HttpRequestUtil httpRequest = null;

    public FireHostDataWriter() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("[" + sdf.format(new Date()) + "] FireHostDataWriter init " + this.name + " start");
        this.log = Logger.getLogger();
        this.dtuHistoryBean = new DtuHistory();
        this.httpRequest = HttpRequestUtil.getHttpRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        Object object = TableLocks.TABLE_LOCK;
        synchronized (object) {
            this.doSave(list);
        }
    }

    public void save2Redis(DeliverBuff.AlarmInfo alarmInfo) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("msg", alarmInfo.toByteArray());
    }

    private void doSave(List<Object> list) {
        block14: {
            System.out.println("list:" + list.toString());
            Connection con = null;
            PreparedStatement pst = null;
            int batchCount = 0;
            String dtu_no = "";
            String conn_point_no = "";
            String protocol_no = "";
            String device_no = "";
            String device_type = "";
            String event = "";
            String stamp = "";
            String postion = "";
            String remarks = "";
            Object tm = null;
            int pIndex = 0;
            try {
                con = ConnectionManager.openConnection();
                con.setAutoCommit(false);
                SQLStr = new StringBuffer();
                SQLStr.append("{call P_INSERTT_HISTORY_FIREHOSTDATA(?,?,?,?,?,?,?,?,?,?,?)}");
                pst = con.prepareStatement(SQLStr.toString());
                int i = 0;
                while (i < list.size()) {
                    Object obj = list.get(i);
                    JSONObject msg = null;
                    if (obj != null) {
                        msg = (JSONObject)obj;
                        try {
                            JSONArray rows = msg.getJSONArray("rows");
                            for (Object object : rows) {
                                JSONObject row = (JSONObject)object;
                                this.log.writeDebugLog("row:" + row.toString());
                                dtu_no = row.getString("dtu_no");
                                conn_point_no = row.getString("conn_point_no");
                                protocol_no = row.getString("protocol_no");
                                device_no = row.getString("device_no");
                                device_type = row.getString("device_type");
                                event = row.getString("event");
                                stamp = row.getString("stamp");
                                postion = row.getString("postion");
                                remarks = row.getString("remarks");
                                if (row.containsKey((Object)"oinfo")) {
                                    String oinfo = String.valueOf(row.get("oinfo"));
                                    this.dtuHistoryBean.insertDtuHistory(dtu_no, HexUtil.stringToHexString(oinfo), oinfo);
                                }
                                pIndex = 1;
                                pst.setString(pIndex++, dtu_no);
                                pst.setInt(pIndex++, Integer.parseInt(conn_point_no));
                                pst.setInt(pIndex++, Integer.parseInt(protocol_no));
                                pst.setString(pIndex++, device_no);
                                pst.setString(pIndex++, device_type);
                                pst.setString(pIndex++, event);
                                pst.setString(pIndex++, stamp);
                                pst.setString(pIndex++, postion);
                                pst.setString(pIndex++, remarks);
                                pst.setString(pIndex++, msg.toString());
                                pst.setString(pIndex++, row.toString());
                                pst.addBatch();
                                if (++batchCount < this.batchSize) continue;
                                pst.executeBatch();
                                con.commit();
                                batchCount = 0;
                            }
                        }
                        catch (Exception e) {
                            this.log.writeErrorLog(e.getMessage());
                            this.log.writeErrorLog("list.toString():" + list.toString());
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                if (batchCount > 0) {
                    pst.executeBatch();
                    con.commit();
                }
                con.setAutoCommit(true);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                IOUtil.closeDB(null, pst, con);
                break block14;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    break block14;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.closeDB(null, pst, con);
                }
            }
            IOUtil.closeDB(null, pst, con);
        }
    }

    public static void main(String[] args) throws JMSException, Exception {
        JedisUtil jedisUtil = JedisUtil.getInstance();
    }
}

