/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.DeliverBuff;
import com.vcarecity.redis.JedisUtil;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.MQWorker;
import com.vcarecity.savedb.database.CmdRecord;
import com.vcarecity.savedb.database.ConnectionManager;
import com.vcarecity.savedb.database.DtuHistory;
import com.vcarecity.savedb.database.Unit;
import com.vcarecity.savedb.database.UnitDataParsingRule;
import com.vcarecity.savedb.database.UnitParsingError;
import com.vcarecity.savedb.mq.DefaultActiveMQWriter;
import com.vcarecity.savedb.mq.MQItem;
import com.vcarecity.savedb.util.DigitalTransUtil;
import com.vcarecity.savedb.util.HexUtil;
import com.vcarecity.savedb.util.HttpRequestUtil;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.StringUtils;
import com.vcarecity.savedb.util.TableLocks;
import com.vcarecity.savedb.util.TimeUtil;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.eclipse.jetty.util.StringUtil;

public class MsgWriter
extends SimpleWriter {
    private static StringBuffer SQLStr = null;
    Logger log = null;
    CmdRecord cmdR = null;
    Unit unitbean = null;
    UnitDataParsingRule unitDataParsingRuleBean = null;
    DtuHistory dtuHistoryBean = null;
    JedisUtil jedisUtil = null;
    MQWorker mq = null;
    DefaultActiveMQWriter writer = null;
    HttpRequestUtil httpRequest = null;

    public MsgWriter() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("[" + sdf.format(new Date()) + "] MsgWriter init " + this.name + " start");
        this.log = Logger.getLogger();
        this.jedisUtil = JedisUtil.getInstance();
        System.out.println("[" + sdf.format(new Date()) + "] MsgWriter init " + this.name + " end");
        this.mq = MQWorker.getInstance();
        this.writer = MQWorker.getWriter("waterData");
        this.cmdR = new CmdRecord();
        this.unitbean = new Unit();
        this.unitDataParsingRuleBean = new UnitDataParsingRule();
        this.dtuHistoryBean = new DtuHistory();
        this.httpRequest = HttpRequestUtil.getHttpRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        Object object = TableLocks.TABLE_LOCK;
        synchronized (object) {
            this.doSave(list);
        }
    }

    public void save2Redis(DeliverBuff.AlarmInfo alarmInfo) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("msg", alarmInfo.toByteArray());
    }

    private void doSave(List<Object> list) {
        block72: {
            Connection con = null;
            PreparedStatement pst = null;
            int batchCount = 0;
            String gatewayNo = "";
            String unitNo = "";
            String protocolNo = "";
            String functionWord = "";
            String equipmentNo = "";
            String deviceId = "";
            Timestamp tm = null;
            int pIndex = 0;
            try {
                con = ConnectionManager.openConnection();
                con.setAutoCommit(false);
                SQLStr = new StringBuffer();
                SQLStr.append("{call P_INSERTT_HISTORY(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
                pst = con.prepareStatement(SQLStr.toString());
                int i = 0;
                while (i < list.size()) {
                    JSONObject msg = (JSONObject)list.get(i);
                    if (msg != null) {
                        this.log.writeDebugLog("msg:" + msg.toString());
                        try {
                            StringBuffer cb = new StringBuffer();
                            cb.append("/0");
                            gatewayNo = msg.getString("gatewayNo");
                            unitNo = msg.getString("unitNo");
                            protocolNo = msg.getString("protocolNo");
                            functionWord = msg.getString("functionWord");
                            equipmentNo = msg.getString("equipmentNo");
                            if (StringUtil.isNotBlank((String)unitNo)) {
                                cb.append("/" + unitNo);
                                deviceId = unitNo;
                            }
                            if (StringUtil.isNotBlank((String)equipmentNo) && !"0".equals(equipmentNo)) {
                                cb.append("/" + equipmentNo);
                                deviceId = equipmentNo;
                            }
                            JSONArray dataItems = msg.getJSONArray("dataItems");
                            for (Object object : dataItems) {
                                JSONObject obj;
                                JSONObject item;
                                JSONArray arr;
                                JSONObject dataItem = (JSONObject)object;
                                int id = Integer.valueOf(dataItem.getString("id"));
                                JSONObject data = dataItem.getJSONObject("data");
                                StringBuffer devicePath = new StringBuffer();
                                devicePath.append(cb.toString());
                                pIndex = 1;
                                if ("1".equalsIgnoreCase(protocolNo)) {
                                    this.log.writeDebugLog("protocolNo_1:" + msg.toString());
                                    if ("DEBUG".equalsIgnoreCase(this.log.getLevel()) && !unitNo.equals("83A41E3AD0D2")) continue;
                                    switch (id) {
                                        case 1537: {
                                            String hostModel;
                                            deviceId = data.getString("deviceId");
                                            if (StringUtil.isNotBlank((String)deviceId) && !"0".equalsIgnoreCase(deviceId)) {
                                                hostModel = data.getString("hostModel");
                                                if ("1".equals(hostModel)) {
                                                    deviceId = String.valueOf(HexUtil.toDecimalString(deviceId, 0, 2, 16)) + "-" + HexUtil.toDecimalString(deviceId, 2, 4, 16) + "-" + HexUtil.toDecimalString(deviceId, 4, 6, 16);
                                                }
                                                devicePath.append("/" + deviceId);
                                            }
                                            devicePath.append("/");
                                            pst.setString(pIndex++, devicePath.toString());
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, Integer.valueOf(data.getString("hostModel")));
                                            pst.setInt(pIndex++, Integer.valueOf(data.getString("eventType")));
                                            pst.setInt(pIndex++, Integer.valueOf(data.getString("event")));
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            tm = TimeUtil.getTimestamp("20" + data.getString("acquisitionTime"), "yyyyMMddHHmmss");
                                            if (tm == null) {
                                                tm = TimeUtil.getTimestamp();
                                                this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                                            }
                                            pst.setTimestamp(pIndex++, tm);
                                            pst.setString(pIndex++, data.getString("desc"));
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            break;
                                        }
                                        case 1538: {
                                            String hostModel = data.getString("hostModel");
                                            String rowCount = data.getString("rowCount");
                                            String dataContent = data.getString("dataContent");
                                            String dtu_no = unitNo;
                                            String eventType = "0";
                                            String desc = "";
                                            Timestamp stamp = null;
                                            String acquisitionTime = "";
                                            String dateStr = "";
                                            String timeStr = "";
                                            if (StringUtil.isBlank((String)dataContent)) break;
                                            String cnDataStr = DigitalTransUtil.hexStringToEncodeString(dataContent.trim(), "GBK");
                                            this.log.writeDebugInfo("dtu_no:" + dtu_no + ",1538_dataContent:" + dataContent + ",cnDataStr:" + cnDataStr);
                                            this.dtuHistoryBean.insertDtuHistory(dtu_no, dataContent, cnDataStr);
                                            System.out.println("dtu_no:" + dtu_no);
                                            JSONArray jarr = this.dataDeal(cnDataStr.trim());
                                            if (jarr.size() == 0) break;
                                            String date = "";
                                            String eventTypeName = "";
                                            String unitType = "";
                                            String postion = "";
                                            for (Object o : jarr) {
                                                JSONObject json = (JSONObject)o;
                                                String dateTime = json.get("stamp").toString();
                                                if (dateTime == null || "19990101010101".equalsIgnoreCase(dateTime) || "2015-01-01 01:01:01".equalsIgnoreCase(dateTime)) {
                                                    this.unitDataParsingRuleBean.insertManufacturerModelNoHex(hostModel, dtu_no, dataContent, cnDataStr.trim(), 3, dateTime);
                                                    continue;
                                                }
                                                stamp = TimeUtil.getTimestamp();
                                                unitType = json.get("unitType").toString();
                                                postion = json.get("postion").toString();
                                                eventType = json.get("eventType").toString();
                                                eventTypeName = json.get("eventTypeName").toString();
                                                deviceId = json.get("deviceid").toString();
                                                data.put((Object)"eventTypeName", (Object)eventTypeName);
                                                StringBuffer thisDevicePath = new StringBuffer();
                                                thisDevicePath.append(devicePath);
                                                if (StringUtil.isNotBlank((String)deviceId) && !"0".equalsIgnoreCase(deviceId)) {
                                                    thisDevicePath.append("/" + deviceId);
                                                }
                                                if ("0".equalsIgnoreCase(deviceId)) {
                                                    deviceId = equipmentNo;
                                                }
                                                thisDevicePath.append("/");
                                                pIndex = 1;
                                                pst.setString(pIndex++, thisDevicePath.toString());
                                                pst.setString(pIndex++, deviceId);
                                                pst.setInt(pIndex++, id);
                                                pst.setInt(pIndex++, Integer.valueOf(hostModel));
                                                pst.setInt(pIndex++, Integer.valueOf(eventType));
                                                pst.setInt(pIndex++, Integer.valueOf(unitType));
                                                pst.setDouble(pIndex++, 0.0);
                                                pst.setDouble(pIndex++, 0.0);
                                                pst.setTimestamp(pIndex++, TimeUtil.getTimestamp(dateTime, "yyyy-MM-dd HH:mm:ss"));
                                                pst.setString(pIndex++, postion);
                                                pst.setString(pIndex++, gatewayNo);
                                                pst.setString(pIndex++, protocolNo);
                                                pst.setString(pIndex++, unitNo);
                                                pst.setString(pIndex++, equipmentNo);
                                                pst.setString(pIndex++, msg.toString());
                                                pst.setString(pIndex++, data.toString());
                                                pst.addBatch();
                                            }
                                            break;
                                        }
                                        case 1793: {
                                            deviceId = equipmentNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            pst.setInt(pIndex++, 399);
                                            pst.setInt(pIndex++, 224);
                                            pst.setDouble(pIndex++, Double.valueOf(data.getString("indication")));
                                            pst.setDouble(pIndex++, 0.0);
                                            tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                                            if (tm == null) {
                                                tm = TimeUtil.getTimestamp();
                                                this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                                            }
                                            pst.setTimestamp(pIndex++, tm);
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            break;
                                        }
                                        case 1794: {
                                            deviceId = equipmentNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            pst.setInt(pIndex++, Integer.valueOf(data.getString("alarmFlag")));
                                            pst.setInt(pIndex++, 224);
                                            pst.setDouble(pIndex++, Double.valueOf(data.getString("indication")));
                                            pst.setDouble(pIndex++, 0.0);
                                            tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                                            if (tm == null) {
                                                tm = TimeUtil.getTimestamp();
                                                this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                                            }
                                            pst.setTimestamp(pIndex++, tm);
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            break;
                                        }
                                        case 720: {
                                            deviceId = data.getString("portNo");
                                            devicePath.append("/" + deviceId);
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            pst.setInt(pIndex++, Integer.valueOf(data.getString("event")));
                                            pst.setInt(pIndex++, 0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                                            if (tm == null) {
                                                tm = TimeUtil.getTimestamp();
                                                this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                                            }
                                            pst.setTimestamp(pIndex++, tm);
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            break;
                                        }
                                        case 1024: {
                                            devicePath.append("/");
                                            pst.setString(pIndex++, devicePath.toString());
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 1);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                                            if (tm == null) {
                                                tm = TimeUtil.getTimestamp();
                                                this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                                            }
                                            pst.setTimestamp(pIndex++, tm);
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            break;
                                        }
                                        case 1025: {
                                            String tmp = data.getString("dataContent");
                                            if (StringUtils.isNotBlank(tmp) && tmp.indexOf("AA") == 0 && (tmp.length() == 50 || tmp.length() == 82)) {
                                                devicePath.append("/");
                                                pst.setString(pIndex++, devicePath.toString());
                                                pst.setString(pIndex++, deviceId);
                                                pst.setInt(pIndex++, id);
                                                pst.setInt(pIndex++, 1);
                                                pst.setInt(pIndex++, id);
                                                pst.setInt(pIndex++, 0);
                                                pst.setDouble(pIndex++, 0.0);
                                                pst.setDouble(pIndex++, 0.0);
                                                pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                                                pst.setString(pIndex++, data.getString("dataContent"));
                                                pst.setString(pIndex++, gatewayNo);
                                                pst.setString(pIndex++, protocolNo);
                                                pst.setString(pIndex++, unitNo);
                                                pst.setString(pIndex++, equipmentNo);
                                                pst.setString(pIndex++, msg.toString());
                                                pst.setString(pIndex++, data.toString());
                                                pst.addBatch();
                                                break;
                                            }
                                            UnitParsingError bean = new UnitParsingError();
                                            bean.insertUnitParsingError(unitNo, data.getString("dataContent"), Integer.parseInt(gatewayNo), Integer.parseInt(protocolNo), Integer.parseInt(equipmentNo));
                                            break;
                                        }
                                        case 130: {
                                            deviceId = unitNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, 2);
                                            pst.setInt(pIndex++, 1);
                                            pst.setInt(pIndex++, 1);
                                            pst.setInt(pIndex++, 0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            int ret = this.unitbean.updateUnitCCID(data.getString("ccid"), unitNo);
                                            data.put((Object)"ret", (Object)String.valueOf(ret));
                                            msg.replace((Object)"functionWord", (Object)"2");
                                            dataItem.put((Object)"data", (Object)data);
                                            dataItem.put((Object)"id", (Object)"2");
                                            this.log.writeDebugLog("\u767b\u5f55\uff1a" + msg.toString());
                                            this.cmdR.sendCommand(gatewayNo, msg);
                                            if (ret != 0) break;
                                            this.unitbean.updateUnitCCID(data.getString("ccid"), unitNo);
                                            this.cmdR.sendCommand(deviceId, gatewayNo);
                                            break;
                                        }
                                        case 131: {
                                            deviceId = unitNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, 3);
                                            pst.setInt(pIndex++, 1);
                                            pst.setInt(pIndex++, 2);
                                            pst.setInt(pIndex++, 0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            break;
                                        }
                                        case 1282: {
                                            deviceId = unitNo;
                                            devicePath = new StringBuffer();
                                            devicePath.append("/0/" + deviceId + "/");
                                            pst.setString(pIndex++, devicePath.toString());
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            pst.setInt(pIndex++, Integer.valueOf(data.getString("alarmFlag")));
                                            pst.setInt(pIndex++, 0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            tm = TimeUtil.getTimestamp("20" + data.getString("dateTime"), "yyyyMMddHHmmss");
                                            if (tm == null) {
                                                tm = TimeUtil.getTimestamp();
                                                this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                                            }
                                            pst.setTimestamp(pIndex++, tm);
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, "0");
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            break;
                                        }
                                        case 110: {
                                            break;
                                        }
                                    }
                                }
                                if ("2".equalsIgnoreCase(protocolNo)) {
                                    this.log.writeDebugLog("protocolNo_2:" + msg.toString());
                                    switch (id) {
                                        case 4: 
                                        case 5: 
                                        case 6: 
                                        case 7: 
                                        case 8: 
                                        case 9: 
                                        case 10: 
                                        case 11: 
                                        case 12: 
                                        case 13: 
                                        case 14: 
                                        case 21: 
                                        case 28: {
                                            deviceId = unitNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            if (id == 4) {
                                                int dataType = Integer.valueOf(data.getString("dataType"));
                                                if (dataType == 2) {
                                                    pst.setInt(pIndex++, 100);
                                                } else {
                                                    pst.setInt(pIndex++, 101);
                                                }
                                            } else {
                                                pst.setInt(pIndex++, id);
                                            }
                                            if (id == 4 || id == 5) {
                                                pst.setInt(pIndex++, Integer.valueOf(data.getString("dataType")));
                                            } else {
                                                pst.setInt(pIndex++, 0);
                                            }
                                            pst.setDouble(pIndex++, Double.valueOf(data.getString("pression")));
                                            pst.setDouble(pIndex++, Double.valueOf(data.getString("temperature")));
                                            tm = TimeUtil.getTimestamp("20" + data.getString("datetime"), "yyyyMMddHHmmss");
                                            if (tm == null) {
                                                tm = TimeUtil.getTimestamp();
                                                this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                                            }
                                            pst.setTimestamp(pIndex++, tm);
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            arr = new JSONArray();
                                            item = new JSONObject();
                                            item.put((Object)"type", (Object)"1");
                                            item.put((Object)"no", (Object)equipmentNo);
                                            item.put((Object)"value", (Object)data.getString("pression"));
                                            item.put((Object)"eventType", (Object)"1");
                                            arr.add((Object)item);
                                            obj = new JSONObject();
                                            obj.put((Object)"deviceID", (Object)"7");
                                            obj.put((Object)"fieldStrength", (Object)"80");
                                            obj.put((Object)"baseStation", (Object)"CELLID:20272;LAC:10067;MCC:460;MNC:0;MCN DIGIT:2;STATUS:1");
                                            obj.put((Object)"fromMachineNumber", (Object)"1");
                                            obj.put((Object)"stamp", (Object)tm.toLocaleString());
                                            obj.put((Object)"dataItems", (Object)arr);
                                            this.writeWaterData(obj);
                                            break;
                                        }
                                        case 2: {
                                            deviceId = unitNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            pst.setInt(pIndex++, 1);
                                            pst.setInt(pIndex++, 0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                                            pst.setString(pIndex++, data.getString("version"));
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            this.cmdR.sendCommand(deviceId, gatewayNo);
                                            this.unitbean.updateUnitCCID(unitNo);
                                            break;
                                        }
                                        case 3: {
                                            deviceId = unitNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            pst.setInt(pIndex++, 2);
                                            pst.setInt(pIndex++, 0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            break;
                                        }
                                        case 100: {
                                            break;
                                        }
                                        case 110: {
                                            break;
                                        }
                                    }
                                }
                                if ("3".equalsIgnoreCase(protocolNo)) {
                                    this.log.writeDebugLog("protocolNo_3:" + msg.toString());
                                    switch (id) {
                                        case 4: 
                                        case 5: 
                                        case 6: 
                                        case 7: 
                                        case 8: 
                                        case 9: 
                                        case 10: 
                                        case 11: 
                                        case 12: 
                                        case 13: 
                                        case 14: 
                                        case 21: 
                                        case 28: {
                                            deviceId = unitNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            if (id == 4) {
                                                int dataType = Integer.valueOf(data.getString("dataType"));
                                                if (dataType == 2) {
                                                    pst.setInt(pIndex++, 100);
                                                } else {
                                                    pst.setInt(pIndex++, 101);
                                                }
                                            } else {
                                                pst.setInt(pIndex++, id);
                                            }
                                            if (id == 4 || id == 5) {
                                                pst.setInt(pIndex++, Integer.valueOf(data.getString("dataType")));
                                            } else {
                                                pst.setInt(pIndex++, 0);
                                            }
                                            pst.setDouble(pIndex++, Double.valueOf(data.getString("pression")));
                                            pst.setDouble(pIndex++, Double.valueOf(data.getString("temperature")));
                                            tm = TimeUtil.getTimestamp("20" + data.getString("datetime"), "yyyyMMddHHmmss");
                                            if (tm == null) {
                                                tm = TimeUtil.getTimestamp();
                                                this.log.writeErrorLog("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef:" + msg.toString());
                                            }
                                            pst.setTimestamp(pIndex++, tm);
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            arr = new JSONArray();
                                            item = new JSONObject();
                                            item.put((Object)"type", (Object)"1");
                                            item.put((Object)"no", (Object)equipmentNo);
                                            item.put((Object)"value", (Object)data.getString("pression"));
                                            item.put((Object)"eventType", (Object)"1");
                                            arr.add((Object)item);
                                            obj = new JSONObject();
                                            obj.put((Object)"deviceID", (Object)"7");
                                            obj.put((Object)"fieldStrength", (Object)"80");
                                            obj.put((Object)"baseStation", (Object)"CELLID:20272;LAC:10067;MCC:460;MNC:0;MCN DIGIT:2;STATUS:1");
                                            obj.put((Object)"fromMachineNumber", (Object)"1");
                                            obj.put((Object)"stamp", (Object)tm.toLocaleString());
                                            obj.put((Object)"dataItems", (Object)arr);
                                            this.writeWaterData(obj);
                                            break;
                                        }
                                        case 2: {
                                            deviceId = unitNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            pst.setInt(pIndex++, 1);
                                            pst.setInt(pIndex++, 0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            int ret = this.unitbean.updateUnitCCID(data.getString("ccid"), unitNo);
                                            data.put((Object)"ret", (Object)String.valueOf(ret));
                                            msg.replace((Object)"functionWord", (Object)"2");
                                            dataItem.put((Object)"data", (Object)data);
                                            dataItem.put((Object)"id", (Object)"2");
                                            this.log.writeDebugLog("\u767b\u5f55\uff1a" + msg.toString());
                                            this.cmdR.sendCommand(gatewayNo, msg);
                                            if (ret != 0) break;
                                            this.unitbean.updateUnitCCID(data.getString("ccid"), unitNo);
                                            this.cmdR.sendCommand(deviceId, gatewayNo);
                                            break;
                                        }
                                        case 3: {
                                            deviceId = unitNo;
                                            pst.setString(pIndex++, String.valueOf(devicePath.toString()) + "/");
                                            pst.setString(pIndex++, deviceId);
                                            pst.setInt(pIndex++, id);
                                            pst.setInt(pIndex++, 0);
                                            pst.setInt(pIndex++, 2);
                                            pst.setInt(pIndex++, 0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setDouble(pIndex++, 0.0);
                                            pst.setTimestamp(pIndex++, TimeUtil.getTimestamp());
                                            pst.setString(pIndex++, "");
                                            pst.setString(pIndex++, gatewayNo);
                                            pst.setString(pIndex++, protocolNo);
                                            pst.setString(pIndex++, unitNo);
                                            pst.setString(pIndex++, equipmentNo);
                                            pst.setString(pIndex++, msg.toString());
                                            pst.setString(pIndex++, data.toString());
                                            pst.addBatch();
                                            break;
                                        }
                                        case 100: {
                                            break;
                                        }
                                        case 110: {
                                            break;
                                        }
                                    }
                                }
                                if (++batchCount < this.batchSize) continue;
                                pst.executeBatch();
                                con.commit();
                                batchCount = 0;
                            }
                        }
                        catch (Exception e) {
                            this.log.writeErrorLog(msg.toString());
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                if (batchCount > 0) {
                    pst.executeBatch();
                    con.commit();
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                IOUtil.closeDB(null, pst, con);
                break block72;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    break block72;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.closeDB(null, pst, con);
                }
            }
            IOUtil.closeDB(null, pst, con);
        }
    }

    public void writeWaterData(JSONObject obj) {
        MQItem mitem = new MQItem();
        mitem.setQueueName("waterData");
        mitem.setData(obj);
        this.writer.addData(mitem);
    }

    public JSONObject dealData(String data, String date_regexp, String deviceid_regexp, String dateFormat, String timeFormat) {
        String item;
        String date = "2015-01-01 01:01:01";
        String stamp = "2015-01-01 01:01:01";
        String deviceid = "0";
        String eventTypeName = "";
        String unitTypeName = "";
        String eventType = "228";
        String unitType = "0";
        String postion = ".";
        Pattern p = null;
        Matcher m = null;
        JSONObject obj = new JSONObject();
        String[] dataDictionaryState = null;
        String[] unitTypes = null;
        dataDictionaryState = StringUtils.Set2Array(this.jedisUtil.hkeys("dataDictionaryState"));
        unitTypes = StringUtils.Set2Array(this.jedisUtil.hkeys("unitType"));
        p = Pattern.compile(date_regexp);
        m = p.matcher(data);
        while (m.find()) {
            date = m.group();
            stamp = TimeUtil.getFullDateTimeString(date, dateFormat, timeFormat).toString();
        }
        System.out.println("dealData stamp:" + stamp);
        p = Pattern.compile(deviceid_regexp);
        m = p.matcher(data);
        if (m.find()) {
            deviceid = m.group();
        }
        System.out.println("deviceid:" + deviceid);
        String[] stringArray = dataDictionaryState;
        int n = dataDictionaryState.length;
        int n2 = 0;
        while (n2 < n) {
            item = stringArray[n2];
            if (data.indexOf(item.toString()) > -1) {
                eventTypeName = item.toString();
                eventType = this.jedisUtil.hget("dataDictionaryState", eventTypeName);
                break;
            }
            ++n2;
        }
        System.out.println("eventTypeName:" + eventTypeName);
        stringArray = unitTypes;
        n = unitTypes.length;
        n2 = 0;
        while (n2 < n) {
            item = stringArray[n2];
            if (data.indexOf(item.toString()) > -1) {
                unitTypeName = item.toString();
                unitType = this.jedisUtil.hget("unitType", unitTypeName);
                break;
            }
            ++n2;
        }
        System.out.println("unitTypeName:" + unitTypeName);
        postion = StringUtils.StringFilterNoStarAndQuestionMark(data.replaceAll(date, "").replaceAll(deviceid, "").replaceAll(eventTypeName, "").replaceAll(unitTypeName, "").replaceAll(" ", ""));
        System.out.println("postion:" + postion);
        if (StringUtils.isBlank(postion)) {
            postion = unitTypeName;
        }
        obj.put((Object)"stamp", (Object)stamp);
        obj.put((Object)"unitTypeName", (Object)unitTypeName);
        obj.put((Object)"unitType", (Object)unitType);
        obj.put((Object)"postion", (Object)postion);
        obj.put((Object)"eventTypeName", (Object)eventTypeName);
        obj.put((Object)"eventType", (Object)eventType);
        obj.put((Object)"deviceid", (Object)deviceid);
        return obj;
    }

    public JSONArray deal(String str, String date_regexp, String deviceid_regexp, String dateFormat, String timeFormat) {
        String datetime;
        System.out.println("str:" + str);
        Pattern p = Pattern.compile("\\d{2}/\\d{2} \\d{2}:\\d{2}");
        Matcher m = p.matcher(str);
        String indexs = "";
        int firstIndex = 0;
        int lastIndex = 0;
        boolean datePos = false;
        boolean splitFlag = false;
        int dateCount = 0;
        boolean deviceidCount = false;
        String format = "";
        JSONObject obj = new JSONObject();
        JSONArray jarr = new JSONArray();
        p = Pattern.compile(date_regexp);
        m = p.matcher(str);
        lastIndex = 0;
        while (m.find()) {
            datetime = m.group();
            ++dateCount;
        }
        if (dateCount == 1) {
            obj = this.dealData(str, date_regexp, deviceid_regexp, dateFormat, timeFormat);
            jarr.add((Object)obj);
        } else if (dateCount > 1) {
            p = Pattern.compile(date_regexp);
            m = p.matcher(str);
            if (m.lookingAt()) {
                format = date_regexp;
            }
            if (StringUtils.isBlank(format) && (m = (p = Pattern.compile(deviceid_regexp)).matcher(str)).lookingAt()) {
                format = deviceid_regexp;
            }
            if (StringUtils.isBlank(format)) {
                p = Pattern.compile(date_regexp);
                m = p.matcher(str);
                lastIndex = 0;
                while (m.find()) {
                    datetime = m.group();
                    lastIndex = m.end();
                }
                if (lastIndex == str.length()) {
                    format = date_regexp;
                }
            }
            if (StringUtils.isBlank(format)) {
                p = Pattern.compile(deviceid_regexp);
                m = p.matcher(str);
                lastIndex = 0;
                while (m.find()) {
                    lastIndex = m.end();
                }
                if (lastIndex == str.length()) {
                    format = deviceid_regexp;
                }
            }
            if (StringUtils.isBlank(format)) {
                p = Pattern.compile(date_regexp);
                m = p.matcher(str);
                firstIndex = 0;
                if (m.find()) {
                    firstIndex = m.start();
                }
                str = str.substring(0, firstIndex);
                return this.deal(str, date_regexp, deviceid_regexp, dateFormat, timeFormat);
            }
            if (StringUtils.isBlank(format)) {
                return jarr;
            }
            p = Pattern.compile(format);
            m = p.matcher(str);
            while (m.find()) {
                datetime = m.group();
                indexs = String.valueOf(indexs) + m.start() + ",";
                lastIndex = m.end();
            }
            indexs = String.valueOf(indexs) + str.length();
            if (lastIndex == str.length()) {
                indexs = "0,";
                m = p.matcher(str);
                while (m.find()) {
                    datetime = m.group();
                    indexs = String.valueOf(indexs) + (m.start() + datetime.length()) + ",";
                }
                datePos = true;
            }
            String[] tmpArr = indexs.split(",");
            System.out.println("tmpArr:" + tmpArr.length);
            if (tmpArr.length > 2) {
                int i = 0;
                while (i < tmpArr.length - 1) {
                    String data = str.substring(Integer.parseInt(tmpArr[i]), Integer.parseInt(tmpArr[i + 1]));
                    System.out.println("data:" + data);
                    obj = this.dealData(data, date_regexp, deviceid_regexp, dateFormat, timeFormat);
                    jarr.add((Object)obj);
                    ++i;
                }
            } else if (tmpArr.length == 2) {
                obj = this.dealData(str, date_regexp, deviceid_regexp, dateFormat, timeFormat);
                jarr.add((Object)obj);
            }
        }
        return jarr;
    }

    public JSONObject singleDataAnalysis(String data) {
        String date = TimeUtil.getLocalTime();
        String stamp = TimeUtil.getLocalTime();
        String deviceid = "0";
        String eventTypeName = "\u6570\u636e\u4f20\u8f93";
        String unitTypeName = "\u6d88\u9632\u4e3b\u673a";
        String eventType = "228";
        String unitType = "0";
        String postion = ".";
        Object p = null;
        Object m = null;
        JSONObject obj = new JSONObject();
        String[] dataDictionaryState = null;
        String[] unitTypes = null;
        dataDictionaryState = StringUtils.Set2Array(this.jedisUtil.hkeys("dataDictionaryState"));
        unitTypes = StringUtils.Set2Array(this.jedisUtil.hkeys("unitType"));
        HashMap hm = StringUtils.getOptimalMatchingDate(data);
        if (hm.size() > 0) {
            date = hm.get("value").toString();
            stamp = TimeUtil.getFullDateTimeString(hm.get("value").toString(), hm.get("regexp").toString()).toString();
        }
        System.out.println("dealData stamp:" + stamp);
        if (StringUtils.isBlank(stamp)) {
            stamp = TimeUtil.getLocalTime();
        }
        String[] stringArray = dataDictionaryState;
        int n = dataDictionaryState.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (data.indexOf(item.toString()) > -1) {
                eventTypeName = item.toString();
                eventType = this.jedisUtil.hget("dataDictionaryState", eventTypeName);
                break;
            }
            ++n2;
        }
        System.out.println("eventTypeName:" + eventTypeName);
        stringArray = unitTypes;
        n = unitTypes.length;
        n2 = 0;
        while (n2 < n) {
            String it = stringArray[n2];
            if (data.indexOf(it.toString()) > -1) {
                unitTypeName = it.toString();
                unitType = this.jedisUtil.hget("unitType", unitTypeName);
                break;
            }
            ++n2;
        }
        System.out.println("unitTypeName:" + unitTypeName);
        String tmpStr = data.replaceAll(date, "").replaceAll(eventTypeName, "").replaceAll(unitTypeName, "");
        hm = StringUtils.getOptimalMatchingDeviceId(StringUtils.getFilterDate(tmpStr));
        if (hm.size() > 0) {
            deviceid = hm.get("value").toString();
        }
        System.out.println("deviceid:" + deviceid);
        if (StringUtils.isBlank(deviceid)) {
            deviceid = "0";
        }
        postion = StringUtils.StringFilterNoStarAndQuestionAndBlankMark(StringUtils.compareStrWithSub(data.replaceAll(date, ""), eventTypeName, unitTypeName, true).replaceAll(deviceid, ""));
        System.out.println("postion:" + postion);
        System.out.println("===================================================");
        if (StringUtils.isBlank(postion)) {
            postion = unitTypeName;
        }
        obj.put((Object)"stamp", (Object)stamp);
        obj.put((Object)"unitTypeName", (Object)unitTypeName);
        obj.put((Object)"unitType", (Object)unitType);
        obj.put((Object)"postion", (Object)postion);
        obj.put((Object)"eventTypeName", (Object)eventTypeName);
        obj.put((Object)"eventType", (Object)eventType);
        obj.put((Object)"deviceid", (Object)deviceid);
        return obj;
    }

    public JSONArray dataDeal(String str) {
        System.out.println("-------------------------------------------------");
        System.out.println("\u8fc7\u6ee4\u524dstr:" + str);
        str = StringUtils.StringFilterSpecificCharacter(StringUtils.qj2bj(str.trim()));
        str = StringUtils.replaceMultiToOneSpace(str.trim());
        str = StringUtils.filterInvisibleCharacter(str.trim());
        System.out.println("\u8fc7\u6ee4\u540estr:" + str);
        Pattern p = Pattern.compile("\\d{2}/\\d{2} \\d{2}:\\d{2}");
        Matcher m = p.matcher(str);
        String findedstr = "";
        String indexs = "";
        int firstIndex = -1;
        boolean secondIndex = false;
        int lastIndex = 0;
        boolean datePos = false;
        boolean splitFlag = false;
        int dateCount = 0;
        int deviceidCount = 0;
        int matcheCount = 0;
        StringUtils.Regexp exp = new StringUtils.Regexp();
        String format = "";
        JSONObject obj = new JSONObject();
        JSONArray jarr = new JSONArray();
        exp = StringUtils.getOptimalMatchingCountAndRegexp(str, StringUtils.getDeviceIdRegExp());
        dateCount = exp.getCount();
        if (dateCount < 1) {
            this.log.writeLog("\u65e0\u6cd5\u5339\u914d\u5230\u65f6\u95f4: " + str);
            exp = StringUtils.getOptimalMatchingCountAndRegexp(str, StringUtils.getDeviceIdRegExp());
            deviceidCount = exp.getCount();
        }
        if (dateCount + deviceidCount < 1) {
            this.log.writeLog("\u65e0\u6cd5\u5339\u914d\u5230\u65f6\u95f4\u6216\u8bbe\u5907\u53f7:" + str);
            return jarr;
        }
        matcheCount = dateCount + deviceidCount;
        if (matcheCount == 1) {
            obj = this.singleDataAnalysis(str);
            jarr.add((Object)obj);
        } else if (matcheCount > 1) {
            String regexp;
            p = Pattern.compile(exp.getRegexp());
            m = p.matcher(str);
            if (m.find()) {
                findedstr = m.group();
                String newStr = findedstr.replace("-", "/");
                str = str.replace(findedstr, newStr);
            }
            if ((m = (p = Pattern.compile(StringUtils.getDateRegExp())).matcher(str)).lookingAt()) {
                format = StringUtils.getDateRegExp();
                firstIndex = 0;
            }
            if (StringUtils.isBlank(format) && (m = (p = Pattern.compile(regexp = StringUtils.getOptimalMatchingRegexp(str, StringUtils.getDeviceIdRegExp()))).matcher(str)).lookingAt()) {
                format = regexp;
                firstIndex = 0;
            }
            if (StringUtils.isBlank(format)) {
                regexp = StringUtils.getOptimalMatchingRegexp(str, StringUtils.getDateRegExp());
                p = Pattern.compile(regexp);
                m = p.matcher(str);
                lastIndex = 0;
                while (m.find()) {
                    String datetime = m.group();
                    lastIndex = m.end();
                }
                if (lastIndex == str.length()) {
                    format = regexp;
                }
            }
            if (StringUtils.isBlank(format)) {
                regexp = StringUtils.getOptimalMatchingRegexp(str, StringUtils.getDeviceIdRegExp());
                p = Pattern.compile(regexp);
                m = p.matcher(str);
                lastIndex = 0;
                while (m.find()) {
                    lastIndex = m.end();
                }
                if (lastIndex == str.length()) {
                    format = regexp;
                }
            }
            if (dateCount > 0 && StringUtils.isBlank(format)) {
                p = Pattern.compile(exp.getRegexp());
                m = p.matcher(str);
                firstIndex = 0;
                if (m.find()) {
                    firstIndex = m.start();
                    findedstr = m.group();
                    str = String.valueOf(str.substring(firstIndex)) + str.substring(0, firstIndex);
                    System.out.println("str===========:" + str);
                }
                return this.dataDeal(str);
            }
            if (deviceidCount > 0 && StringUtils.isBlank(format)) {
                p = Pattern.compile(exp.getRegexp());
                m = p.matcher(str);
                firstIndex = 0;
                if (m.find()) {
                    firstIndex = m.start();
                    findedstr = m.group();
                    str = String.valueOf(str.substring(firstIndex)) + str.substring(0, firstIndex);
                    System.out.println("str===========:" + str);
                }
                return this.dataDeal(str);
            }
            if (StringUtils.isBlank(format)) {
                return jarr;
            }
            if (firstIndex == 0) {
                p = Pattern.compile(format);
                m = p.matcher(str);
                while (m.find()) {
                    findedstr = m.group();
                    indexs = String.valueOf(indexs) + m.start() + ",";
                    lastIndex = m.end();
                }
                indexs = String.valueOf(indexs) + str.length();
            }
            if (lastIndex == str.length()) {
                indexs = "0,";
                m = p.matcher(str);
                while (m.find()) {
                    findedstr = m.group();
                }
                datePos = true;
            }
            String[] tmpArr = indexs.split(",");
            System.out.println("tmpArr:" + tmpArr.length);
            if (tmpArr.length > 2) {
                int i = 0;
                while (i < tmpArr.length - 1) {
                    String data = str.substring(Integer.parseInt(tmpArr[i]), Integer.parseInt(tmpArr[i + 1]));
                    System.out.println("data:" + data);
                    obj = this.singleDataAnalysis(data);
                    jarr.add((Object)obj);
                    ++i;
                }
            } else if (tmpArr.length == 2) {
                obj = this.singleDataAnalysis(str);
                jarr.add((Object)obj);
            }
        }
        return jarr;
    }

    public static void main(String[] args) throws JMSException, Exception {
        JedisUtil jedisUtil = JedisUtil.getInstance();
        MsgWriter bean = new MsgWriter();
        String unitDataParsingRule = jedisUtil.hget("manufacturerModelNo", "MANUFACTURER_MODEL_NO_14");
        System.out.println("unitDataParsingRule:" + unitDataParsingRule);
        HashMap hm = StringUtils.JSONObjectStringToHashMap(unitDataParsingRule);
        String cnDataStr = "\u706b\u8b66:01-069 \u5149\u7535\u611f\u70df 16-04-09 16:47 \u4e00\u5143\u5e97";
        cnDataStr = "04-15 16:04  000701 \u7535\u8bdd\u63d2\u5b54\u91ca\u653e";
        cnDataStr = "05-05 16:58  000000 \u590d\u4f4d \u64cd\u4f5c";
        cnDataStr = "\u6545\u969c 05-24 13:37 000064 \u5907\u7535\u6e90";
        cnDataStr = "\u706b\u8b66 03-17 10:15 081004   \u70b9\u578b\u611f\u6e29\u58f0\u5149\u62a5\u8b66 ";
        cnDataStr = "\u706b\u8b66 07-18 23:57 011026   \u70b9\u578b\u611f\u70df**********";
        cnDataStr = "5\u5c42\u975e\u70e4\u52ff\u6270525023    \u70b9\u578b\u611f\u70df\u706b\u8b66  7\u670826\u65e516:08";
        cnDataStr = "16/09/28 01:25:44 1-95 \u611f\u70df\u706b\u8b66 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "1-95 \u611f\u70df\u706b\u8b66 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "16/09/28 01:25:44  \u611f\u70df\u706b\u8b66 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "\u611f\u70df\u706b\u8b66 16/09/28 01:25:44 1-95 \u611f\u70df\u706b\u8b66 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "\u611f\u70df\u706b\u8b66 16/09/28 01:25:44 1-95 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "\u611f\u70df\u706b\u8b66 16/09/28 01:25:44 1-95 \u4e00\u5c42\u5927\u5385\u70df\u611f \u611f\u70df\u706b\u8b66 16/09/28 01:25:44 1-95 \u4e00\u5c42\u5927\u5385\u70df\u611f";
        cnDataStr = "\u5149\u7535\u611f\u70df 02-05 \u901a\u8baf\u6545\u969c 16/03/31 07:27:01 \u5939\u5c42\u5546\u573a\u70df\u611f \u5149\u7535\u611f\u70df 02-03 \u901a\u8baf\u6545\u969c 16/03/31 07:28:03 \u5939\u5c42\u5546\u573a\u70df\u611f";
        cnDataStr = "\u706b\u8b6610F  \u5149\u7535\u63a2\u6d4b\u56682016.11.08   15:28:29   0103221";
        cnDataStr = StringUtils.StringFilterSpecificCharacter("8\u4e8b\u4ef6:\u5668\u4ef6\u6545\u969c\u7f16\u53f7:0002208\u7c7b\u578b:\u76d1\u7ba1\u8f93\u5165\u5730\u70b9:10\u5c42\u4fe1\u53f7\u9600\u65f6\u95f4:2016/12/06 16:12");
        cnDataStr = "\u706b\u8b66:002-094 \u5149\u7535\u611f\u70df 16-12-06 19:50 \u5730\u4e0b\u5ba4\u6cf5\u623f\u70df\u611f";
        cnDataStr = "\u706b\u8b66:01-161 \u5149\u7535\u611f\u70df 16-12-06 22:29 \u5927\u5802";
        cnDataStr = "\u590d\u4f4d 16-12-06 22:32 ";
        cnDataStr = "001-232 \u8f93\u5165\u6a21\u5757 \u53cd\u9988 16-12-07 04:45 B22-2";
        cnDataStr = "001-232 \u8f93\u5165\u6a21\u5757 \u53cd\u9988\u505c\u6b62 16-12-07 05:53 B22-2";
        cnDataStr = "\u706b\u8b66:002-050 \u5149\u7535\u611f\u70df 16-12-07 03:49 \u4e09\u697c\u8d70\u9053\u5de6\u70df\u611f";
        cnDataStr = "001-232 \u8f93\u5165\u6a21\u5757 \u53cd\u9988 16-12-07 06:26 B22-2";
        cnDataStr = "12/07 16:04 10-097\u624b\u52a8\u64a4\u6d8810\u5c42\u5e7f\u64ad\u6a21\u5757";
        String hex = "";
        hex = "2020CAB1BCE43A323031362F31312F32392031343A31303A30350D0A2020283030312D30363529303031B6B03034C7F83033B2E320303635BAC50D0A2020B5D8D6B7B6AACAA72120B9E2B5E7CCBDCDB720303033B7D6BBFA0D0A0D0A";
        hex = "31362F31302F32312031373A33303A333420BFAABBFA00";
        hex = "26BBFABAC5A3BA1C2E303120201C26BBD8C2B7A3BA1C2E30370A1C26B5E3BAC5A3BA1C2E303335201C26B7D6C7F8A3BA1C2E303035310A1C26C0E0D0CDA3BAB8D0D1CCCCBDCDB7201C26D7B4CCAC20BBF0BEAF0A1C26CAB1BCE4A3BA1C2E323031362E31322E30382030383A35390AC3E8CAF6A3BA1C26A3B5B2E3A3C1B6B0A3B5A3B1A3B8B7BF0A200A";
        hex = "B9CAD5CFCFFBB3FD39B2E3CEF7B5E7CCDDC7B0CAD22020B9E2B5E7CCBDB2E2C6F7B6AACAA7323031362E31322E303920202030383A32373A30362020203031303331353300";
        hex = "B9CAD5CF2020202020202020202020204946432D333033302020202020B5DA31BBD8C2B7BDD3B5D8202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020204E32543837202020202020202031383A31313A313820202020323031362D31322D370D0AB9CAD5CF2020202020202020202020204946432D333033302020202020B5DA33BBD8C2B7BDD3B5D8202020202020202020202020202020202020202020202020202020202020202020202020";
        hex = "20202020202031303A34343A3239202031322C31322C32303136204E3030312020202020202020CFFBB7C0B1A8BEAF31BAC5D6F7BBFA2020202020202020202020202020CFB5CDB3B3F5CABCBBAF2020202020202020202020202020202020202020BBF0BEAFB9CAD5CFBCBAC7E5B3FD2020202020202020202020202020202000";
        hex = "31322D31332030383A3335202031313130353620B5E3D0CDB8D0D1CCB9CAD5CF20B7B9CCC33120C2A5C3C6B6A5B2E320";
        hex = "B9CAD5CF202020202020202020202020B8D0D1CC28B9E2B5E729202020CCBDB2E2C6F7204C30324430313820202020202020202020202020202020202020202020202020202020BDF4BCB1CEACBBA4202020202020204E334C3244313820202020202032333A35303A323420202020323031372D312D330D0AB9CAD5CFB1A8BEAFBDE2B3FD20202020B8D0D1CC28B9E2B5E729202020CCBDB2E2C6F7204C30324430313820202020202020202020202020202020202020202020202020202020BDF4BCB1CEAC";
        hex = "B1A8BEAF202020202020202020202020B8D0CEC2202020202020202020D6F7C2A5B6FEB2E3CEF7B2CDB3F8B7BF2028D6F7C2A5B6FEB2E3292020202020202020202020202020205A6F6E6520303036202020202020204E324C34443536202020202020393A35373A33352020202020323031372D312D340D0A";
        hex = "B1A8BEAF202020202020202020202020BBF0BEAFBCE0CAD32020202020C9CCD2B5D6D0D0C4D2BBB2E33423CAD6B6AFB1A8BEAFB0B4C5A5B1A8BEAFBCE0CAD32028C9CCD2B5D6205A6F6E6520303031202020202020204E334C314D3238202020202020383A33383A33312020202020323031372D312D350D0AC6F4B6AF202020202020202020202020BCCCB5E7C6F720202020202020C9CCD2B5D6D0D0C4D2BBB2E33141454C312D31BEEDC1B1C8ABBDB5BFD8D6C62028C9CCD2B5D6D0D0C4205A6F6E652030";
        hex = "B9CAD5CF2032372D443031";
        hex = "30312D30342030323A3033202030343530393520B5E3D0CDB8D0D1CCBBF0BEAF";
        hex = "30312D30342030323A3033202030343530393520B5E3D0CDB8D0D1CCBBF0BEAF20";
        hex = "A3C2CAAED2BBA3B2CCDDA3B1A3B9B2E30A0DCFFBBBF0CBA8B0B4C5A5200A0D0A0D1B3630322D32332031333A35322020202031332D3038350A0D1B39BBF0BEAFBAF3D0F8200A0DA3C2CAAED2BBA3B2CCDDA3B1A3B9B2E30A0DCFFBBBF0CBA8B0B4C5A5200A0D0A0D1B3630322D32332031333A35322020202031352D3135350A0D1B39BBF0BEAFBAF3D0F8200A0DA3C3A3B6B6B0CAD2CDE20A0DCFFBBBF0CBA8B0B4C5A5200A0D0A0D1B3630322D32332031333A35322020202032312D3136390A0D";
        hex = "3030BBFA3031C2B7313033BAC52020202031B6B0202034B2E3D7FAD7FAD7FAD7FA0A3130D4C23131C8D53131CAB13232B7D620BBF0BEAF0A0A3030BBFA3031C2B7313030BAC52020202031B6B0202035B2E3D7FAD7FAD7FAD7FA0A3130D4C23131C8D53131CAB13232B7D620BBF0BEAF0A0A3030BBFA3031C2B7313033BAC52020202031B6B0202034B2E3D7FAD7FAD7FAD7FA0A3131D4C23031C8D53039CAB13536B7D620BBF0BEAF0A0A3030BBFA3031C2B7313030BAC52020202031B6B0202035B2E3D7FA";
        hex = "1B401B31051B361B3931372F30332F30342031333A33343A32340A3030C2A53032B2E33030B7BFBCE40AD7A1D4BAB2BF000000000AD7DFB5C00000000000000AB9CAD5CF3A30363033330AB8D0D1CC0A1B4A011B39";
        hex = "BBF0BEAF2030332D30372031363A33372030393130303520202020B5E3D0CDB8D0D1CCD6C7B3C7BBE1D2C7CAD2D5B9B0E5";
        hex = "323031372E30332E313920202031323A30303A3032202020303130313031362020B9E2B5E7CCBDB2E2C6F72020BBF0BEAF2032B2E33136BAC52020202000";
        hex = "1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401C2E1B401B40323031372E30332E323220202030393A32343A3530202020303130313030310A1C26C6F70DB6FEC7F82D31B2E331B7BF2020B8D0CEC2CCBDB2E20D1C2E1B69011C26BBF0BEAF1C2E1B69001B69013030311B69001B6C0C1C26";
        hex = "43C7F8B3B5BFE243321C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3531202020303132363032380A1C26C6F70DB6FEC7F82D31B2E33238B7BF2020B8D0CEC2CCBDB2E20D1C2E1B69011C26BBF0BEAF1C2E1B69001B69013030321B69001B6C0C1C2642C7F84232B3B5BFE21C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3531202020303130303033330A1C26C6F70DD2BBC7F82D31B2E33333B7BF2020B8D0CEC2CCBDB2E20D1C2E1B";
        hex = "0DD2BBC7F82D31B2E33534B7BF2020B8D0CEC2CCBDB2E20D1C2E1B69011C26BBF0BEAF1C2E1B69001B69013030351B69001B6C0C1C2643C7F8B3B5BFE243321C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3534202020303130303035350A1C26C6F70DD2BBC7F82D31B2E33535B7BF2020B8D0CEC2CCBDB2E20D1C2E1B69011C26BBF0BEAF1C2E1B69001B69013030361B69001B6C0C1C2643C7F8B3B5BFE243321C2E0D1B6C000D0A1B40323031372E30332E32";
        hex = "3220202030393A32343A3534202020303131343133300A1C26BEEDC1B1C8ABBDB50DBFE2B7C0BBF0C8FDC7F82D31B2E3313330B7BF20200D1C2E1B69011C26B7B4C0A11C2E1B69001B69013030311B69001B6C0C1C2641C7F8B5D8CFC2B3B51C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3534202020303131323133310A1C26C5C5D1CCB7A70DBFE2B7C0BBF0D2BBC7F82D31B2E3313331B7BF20200D1C2E1B69011C26B7B4C0A11C2E1B69001B69013030321B";
        hex = "69001B6C0C1C2641C7F8B5D8CFC2B3B51C2E0D1B6C000D0A1B40323031372E30332E323220202030393A32343A3537202020303131363138380A1C26B7BFCBCDB7E7BBFA3838BAC52020CBCDB7E7BBFA0D1C2E1B69011C26B7B4C0A11C2E1B69001B69013030331B69001B6C0C1C264231C7F8B3B5BFE231231C2E0D1B6C000D0A1C2E1B401C2E1B401C2E1B401C2E1B401C2E1B40";
        hex = "0D0A2020BBF0BEAF21202020323031372F30342F31322031323A30363A34340D0A2020CFFBB7C0CBA9C5A5202020203031B6B03031C7F83031B2E3303136BAC50D0A";
        hex = "30342D30372030313A3333202032313830393120B5E3D0CDB8D0D1CCBBF0BEAF203220B2E3B0FCD7B0BCE420";
        cnDataStr = DigitalTransUtil.hexStringToEncodeString(hex.trim().replace(" ", ""), "GBK");
        cnDataStr = "17\u5e7406\u670830\u65e512\u65f628\u5206 \u70df\u611f 001\u8def009\u53f7 \u6545\u969c  1\u680b 1\u5c42\ue810\u8d85\u5e02\ue81017\u5e7406\u670830\u65e512\u65f628\u5206 \u70df\u611f 003\u8def130\u53f7 \u6545\u969c  1\u680b 3\u5c42\ue810\u8d85\u5e02";
        JSONArray jarr = bean.dataDeal(cnDataStr.trim());
    }
}

