/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.CommandBuff;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.database.ConnectionManager;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.TableLocks;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class OnLineCheckResponseWriter
extends SimpleWriter {
    Logger log = Logger.getLogger();

    @Override
    public void init() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("[" + sdf.format(new Date()) + "] OnLineCheckResponseWriter init " + this.name + " start");
        System.out.println("[" + sdf.format(new Date()) + "] OnLineCheckResponseWriter init " + this.name + " end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        Object object = TableLocks.TABLE_LOCK;
        synchronized (object) {
            this.doSave(list);
        }
    }

    public void save2Redis(CommandBuff.OnLineCheckResponse info) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("onLineCheckResponse", info.toByteArray());
    }

    public void doSave(List<Object> list) {
        Connection con = null;
        PreparedStatement pst = null;
        int batchCount = 0;
        int pIndex = 0;
        String sql = "{call P_UPDATE_UNIT_ONLINE(?,?,?,?,?)}";
        try {
            try {
                con = ConnectionManager.openConnection();
                con.setAutoCommit(false);
                pst = con.prepareStatement(sql);
                int i = 0;
                while (i < list.size()) {
                    JSONObject data = (JSONObject)list.get(i);
                    JSONArray units = data.getJSONArray("units");
                    this.log.writeDebugLog("units:" + units);
                    for (Object obj : units) {
                        JSONObject o = (JSONObject)obj;
                        if (o.size() <= 3) continue;
                        pIndex = 1;
                        pst.setString(pIndex++, o.getString("gatewayNo"));
                        pst.setString(pIndex++, o.getString("protocolNo"));
                        pst.setString(pIndex++, o.getString("equipmentNo"));
                        pst.setString(pIndex++, o.getString("unitNo"));
                        pst.setInt(pIndex++, o.getInt("isOnLine"));
                        pst.addBatch();
                        if (++batchCount < this.batchSize) continue;
                        pst.executeBatch();
                        con.commit();
                        batchCount = 0;
                    }
                    ++i;
                }
                if (batchCount > 0) {
                    pst.executeBatch();
                    con.commit();
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeDB(null, pst, con);
            throw throwable;
        }
        IOUtil.closeDB(null, pst, con);
    }
}

