/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.savedb.writer.CmdResponseWriter;
import com.vcarecity.savedb.writer.FireHostDataWriter;
import com.vcarecity.savedb.writer.MsgWriter;
import com.vcarecity.savedb.writer.OnLineCheckResponseWriter;
import com.vcarecity.savedb.writer.OracleWriter;
import com.vcarecity.savedb.writer.ProtocolStructureWriter;
import com.vcarecity.savedb.writer.UnitRegisterWriter;
import java.util.HashMap;
import java.util.Map;

public class OracleWriterFactory {
    private static Map<String, Class<? extends OracleWriter>> classMap = new HashMap<String, Class<? extends OracleWriter>>();

    static {
        classMap.put("msg", MsgWriter.class);
        classMap.put("cmdResponse", CmdResponseWriter.class);
        classMap.put("register", UnitRegisterWriter.class);
        classMap.put("onLineCheckResponse", OnLineCheckResponseWriter.class);
        classMap.put("protocolStructure", ProtocolStructureWriter.class);
        classMap.put("fireHostData", FireHostDataWriter.class);
    }

    public static OracleWriter getWriter(String typeName) {
        Class<? extends OracleWriter> cls = classMap.get(typeName);
        OracleWriter instance = null;
        try {
            instance = cls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }
}

