/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.DeliverBuff;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.database.ConnectionManager;
import com.vcarecity.savedb.util.IOUtil;
import com.vcarecity.savedb.util.TableLocks;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;

public class ProtocolStructureWriter
extends SimpleWriter {
    private static final String sql = "{call P_INSERTT_PROTOCOL_STRUCTURE(?,?)}";

    @Override
    public void init() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("[" + sdf.format(new Date()) + "] ProtocolStructureWriter init " + this.name + " start");
        System.out.println("[" + sdf.format(new Date()) + "] ProtocolStructureWriter init " + this.name + " end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        Object object = TableLocks.TABLE_LOCK;
        synchronized (object) {
            this.doSave(list);
        }
    }

    public void save2Redis(DeliverBuff.AlarmInfo alarmInfo) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("protocolStructure", alarmInfo.toByteArray());
    }

    private void doSave(List<Object> list) {
        Connection con = null;
        PreparedStatement pst = null;
        int batchCount = 0;
        int pIndex = 0;
        String stamp = "";
        try {
            try {
                con = ConnectionManager.openConnection();
                con.setAutoCommit(false);
                pst = con.prepareStatement(sql);
                int i = 0;
                while (i < list.size()) {
                    JSONObject data = (JSONObject)list.get(i);
                    pIndex = 1;
                    pst.setString(pIndex++, data.getString("protocolNo"));
                    pst.setString(pIndex++, data.getString("function"));
                    pst.addBatch();
                    if (++batchCount >= this.batchSize) {
                        pst.executeBatch();
                        con.commit();
                        batchCount = 0;
                    }
                    ++i;
                }
                if (batchCount > 0) {
                    pst.executeBatch();
                    con.commit();
                }
            }
            catch (NumberFormatException e) {
                System.out.println("stamp:" + stamp);
                e.printStackTrace();
            }
            catch (SQLException e) {
                System.out.println("stamp:" + stamp);
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeDB(null, pst, con);
            throw throwable;
        }
        IOUtil.closeDB(null, pst, con);
    }
}

