/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.savedb.writer;

import com.vcarecity.buff.DeliverBuff;
import com.vcarecity.redis.RedisClient;
import com.vcarecity.savedb.MQWorker;
import com.vcarecity.savedb.database.Unit;
import com.vcarecity.savedb.mq.DefaultActiveMQWriter;
import com.vcarecity.savedb.mq.MQItem;
import com.vcarecity.savedb.util.Logger;
import com.vcarecity.savedb.util.TableLocks;
import com.vcarecity.savedb.writer.SimpleWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.eclipse.jetty.util.StringUtil;

public class UnitRegisterWriter
extends SimpleWriter {
    Unit databean = null;
    Logger log = null;

    @Override
    public void init() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("[" + sdf.format(new Date()) + "] ProtocolStructureWriter init " + this.name + " start");
        this.databean = new Unit();
        this.log = Logger.getLogger();
        System.out.println("[" + sdf.format(new Date()) + "] ProtocolStructureWriter init " + this.name + " end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveDataToDB(List<Object> list) throws Exception {
        Object object = TableLocks.TABLE_LOCK;
        synchronized (object) {
            this.doSave(list);
        }
    }

    public void save2Redis(DeliverBuff.RegInfo regInfo) {
        RedisClient client = RedisClient.getInstance();
        client.rpush("RegInfo", regInfo.toByteArray());
    }

    public void doSave(List<Object> list) {
        String gatewayNo = "";
        String unitNo = "";
        String protocolNo = "";
        String functionWord = "";
        String equipmentNo = "";
        String deviceId = "";
        try {
            MQWorker mq = MQWorker.getInstance();
            DefaultActiveMQWriter writer = MQWorker.getWriter("registerResponse");
            int i = 0;
            while (i < list.size()) {
                JSONObject obj = (JSONObject)list.get(i);
                if (obj == null) {
                    System.out.println("doSave i=" + i + " msg==null list:" + list);
                } else {
                    StringBuffer cb = new StringBuffer();
                    cb.append("/0");
                    gatewayNo = obj.getString("gatewayNo");
                    unitNo = obj.getString("unitNo");
                    protocolNo = obj.getString("protocolNo");
                    functionWord = obj.getString("functionWord");
                    equipmentNo = obj.getString("equipmentNo");
                    if (StringUtil.isNotBlank((String)unitNo)) {
                        cb.append("/" + unitNo);
                        deviceId = unitNo;
                    }
                    if (StringUtil.isNotBlank((String)equipmentNo) && !"0".equals(equipmentNo)) {
                        cb.append("/" + equipmentNo);
                        deviceId = equipmentNo;
                    }
                    JSONArray dataItems = obj.getJSONArray("dataItems");
                    for (Object object : dataItems) {
                        String ccid;
                        JSONObject dataItem = (JSONObject)object;
                        JSONObject params = dataItem.getJSONObject("data");
                        this.log.writeLog("params:" + params.toString());
                        if ("1".equals(protocolNo)) {
                            String imei = params.getString("IMEI");
                            dataItem.put((Object)"id", (Object)"1");
                            dataItem.put((Object)"data", (Object)String.valueOf(this.databean.dtuRegister(deviceId, imei)));
                        }
                        if ("2".equals(protocolNo)) {
                            ccid = params.getString("ccid");
                            dataItem.put((Object)"data", (Object)String.valueOf(this.databean.waterRegister(ccid)));
                        }
                        if ("3".equals(protocolNo)) {
                            ccid = params.getString("ccid");
                            dataItem.put((Object)"data", (Object)String.valueOf(this.databean.waterRegister(ccid)));
                        }
                        JSONArray reDataItems = new JSONArray();
                        reDataItems.add((Object)dataItem);
                        obj.put((Object)"dataItems", (Object)reDataItems);
                        obj.put((Object)"SN", (Object)"1");
                        obj.put((Object)"functionWord", (Object)"1");
                        this.log.writeLog("reDataItems:" + reDataItems.toString());
                        MQItem mitem = new MQItem();
                        mitem.setQueueName("registerResponse");
                        mitem.setData(obj);
                        writer.addData(mitem);
                    }
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

