package com.vcarecity.dtu.common.constant;

/**
 * @author Kerry on 18/04/09
 */

public final class DtuProtocolConfig {

    /**
     * 登录上报
     */
    public static final int CODE_LOGIN = 130;
    /**
     * 心跳上报
     */
    public static final int CODE_HEART_BEAT = 132;
    /**
     * 读取回复
     */
    public static final int CODE_READ_RESP = 144;
    /**
     * 设备回复
     */
    public static final int CODE_WRITE_RESP = 160;
    /**
     * 上报数据
     */
    public static final int CODE_REPORT = 176;

    /**
     * 登录回复
     */
    public static final int CODE_LOGIN_RESP = 2;

    /**
     * 心跳回复
     */
    public static final int CODE_HEART_BEAT_RESP = 4;


    /**
     * 下发读取
     */
    public static final int CODE_READ = 16;
    /**
     * 下发设备
     */
    public static final int CODE_WRITE = 32;


    public static byte[] DTU_MASK = new byte[]{0x7e, 0x7e, 0x7e};

    /**
     * 头部长度,7e7e7e
     */
    public static final int DTU_MASK_LEN = DTU_MASK.length;
    /**
     * 设备地址
     */
    public static final int DTU_DEVICE_ID_LEN = 6;
    /**
     * 功能码长度
     */
    public static final int DTU_FUNC_LEN = 1;
    /**
     * 数据长度所占的长度
     */
    public static final int DTU_LEN_LEN = 2;
    /**
     * 消息流水号所占长度
     */
    public static final int DTU_MSG_FLOW_LEN = 2;
    /**
     * 测量点所占长度
     */
    public static final int DTU_EQUIPMENT_NO_LEN = 1;
    /**
     * 数据帧ID所占长度
     */
    public static final int DTU_INFO_ID_LEN = 2;
    /**
     * CRC检验码所占长度
     */
    public static final int DTU_CRC_LEN = 1;

    /**
     * 下发设备指令回复时,设置结果所占长度
     */
    public static final int DTU_WRITE_INFO_RESULT_LEN = 1;


}
