package com.vcarecity.dtu.common.frame;

import com.vcarecity.dtu.common.context.BaseJsonViewBean;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/06/27
 */

public interface IDtuFrameParser extends IFrameParser {

    /**
     * 返回当前所占的长度,如:0710 它后面所占数据长度,如果不确定返回-1
     * <p>
     * 不包函 0710 本身所占长度
     *
     * @return
     */
    int getCurrentCodeLength();

    /**
     * 组装数据
     *
     * @param dataType
     * @param data
     * @return
     */
    List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data);

    /**
     * 当一个数据时,返回单个List
     *
     * @param dataType
     * @param data
     * @return
     */
    default List<BaseJsonViewBean.DataItemDTO> parserOneDataItem(Integer dataType, Map<String, Object> data) {
        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, data));
    }
}
