package com.vcarecity.dtu.common.service;

import com.vcarecity.dtu.common.context.BaseJsonViewBean;
import com.vcarecity.dtu.common.exception.NoRequireKeyException;

/**
 * @author KerryZhang
 * 转换JSON对象成为Byte[]的接口
 */
public interface IConvertJsonService {
    /**
     * 获取指令的回复
     *
     * @param messageContext
     * @return null 代表不用回复或者组织回复帧失败
     * @throws NoRequireKeyException
     */
    byte[] convertJson(BaseJsonViewBean messageContext) throws NoRequireKeyException;

    /**
     * 获取回应信息,为人让人用起来简单点,一眼就看懂...
     *
     * @param messageContext
     * @return
     */
    default byte[] getResponse(BaseJsonViewBean messageContext) {
        try {
            return convertJson(messageContext);
        } catch (NoRequireKeyException e) {
            e.printStackTrace();
        }
        return null;
    }
}
