package com.vcarecity.dtu.common.service.sub;

import com.vcarecity.dtu.common.context.BaseJsonViewBean;
import com.vcarecity.dtu.common.exception.NoRequireKeyException;

import java.util.Map;

/**
 * @author Kerry on 18/06/27
 */

public interface IConverter {
    /**
     * 主要用于上报指令的回复
     *
     * @param message
     * @return
     */
    default byte[] convert(BaseJsonViewBean message) {
        try {
            return convertMessage(message);
        } catch (NoRequireKeyException ignored) {
            return null;
        }
    }

    /**
     * 主要用于下发指令的生成指令,会报异常
     *
     * @param message
     * @return
     * @throws NoRequireKeyException
     */
    byte[] convertMessage(BaseJsonViewBean message) throws NoRequireKeyException;


    /**
     * 转换单个DataItem
     *
     * @param sn
     * @param equipmentNo
     * @param id
     * @param data
     * @return
     * @throws NoRequireKeyException
     */
    byte[] itemBodyConverter(Integer sn, Integer equipmentNo, Integer id, Map<String, Object> data) throws NoRequireKeyException;
}
