package com.vcarecity.dtu.common.util;

import com.sun.org.apache.bcel.internal.generic.LNEG;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

import java.nio.channels.Channel;
import java.nio.charset.Charset;
import java.sql.SQLSyntaxErrorException;
import java.util.Arrays;

/**
 * @author Kerry on 18/05/24
 */

public final class HexUtil {


    public static String byteArrayToHex(byte[] data, boolean lowCase) {
        if (data == null) {
            return null;
        }
        if (lowCase) {
            return Hex.encodeHexString(data);
        }
        return Hex.encodeHexString(data).toUpperCase();
    }

    public static String byteArrayToHex(byte[] bs) {
        if (bs == null) {
            return null;
        }
        return Hex.encodeHexString(bs).toUpperCase();
    }

    public static byte[] hexToByteArray(String hex) {
        try {
            return Hex.decodeHex(hex);
        } catch (DecoderException e) {
            return new byte[0];
        }
    }

    public static byte[] hexToByteArray(String hex, int len) {
        try {
            byte[] bytes = Hex.decodeHex(hex);
            if (bytes.length == len) {
                return bytes;
            }
            if (bytes.length < len) {
                byte[] result = new byte[len];
                System.arraycopy(bytes, 0, result, len - bytes.length, bytes.length);
                return result;
            } else {
                return Arrays.copyOf(bytes, len);
            }
        } catch (DecoderException e) {
            return new byte[len];
        }
    }

    /**
     * 二维数组合并成一维数组
     *
     * @param bs
     * @return
     */
    public static byte[] reduceDimension(byte[][] bs) {
        int size = 0;
        for (byte[] b: bs) {
            size += b.length;
        }
        byte[] res = new byte[size];
        int pos = 0;
        for (byte[] b: bs) {
            System.arraycopy(b, 0, res, pos, b.length);
            pos += b.length;
        }
        return res;
    }

    public static byte[] strToByte(String str) {
        return str.getBytes();
    }

    public static byte[] strToByte(String str, String charsetName) {
        return str.getBytes(Charset.forName(charsetName));
    }

    public static byte[] strToByte(String str, int len) {
        byte[] bytes = str.getBytes();
        if (bytes.length > len) {
            return Arrays.copyOf(bytes, len);
        }
        byte[] result = new byte[len];
        System.arraycopy(bytes, 0, result, len - bytes.length, bytes.length);
        return result;
    }

    public static byte[] strToByte(String str, int len, String charsetName) {
        byte[] bytes = str.getBytes(Charset.forName(charsetName));
        if (bytes.length > len) {
            return Arrays.copyOf(bytes, len);
        }
        byte[] result = new byte[len];
        System.arraycopy(bytes, 0, result, len - bytes.length, bytes.length);
        return result;
    }


    public static int byteArrayToInt(byte[] data) {
        if (data == null || data.length < 1 || data.length > 4) {
            return -1;
        }
        int result = 0;
        int len = data.length;
        for (int i = 0; i < len; i++) {
            int ch = byteToInt(data[len - 1 - i]);

            result += ch << (8 * i);
        }
        if (data.length == 1 && result < 0) {
            result += 256;
        }
        return result;
    }

    public static int byteToInt(byte data) {
        return (data & 0xff);
    }


    public static byte[] intToByteArray(Object value, int arrayLen) {
        if (value == null) {
            return null;
        }
        return intToByteArray(Integer.parseInt(value.toString()), arrayLen);
    }


    /**
     * 数字转换成byte[]数组
     *
     * @param value
     * @param arrayLen 数组长度
     * @return
     */
    public static byte[] intToByteArray(int value, int arrayLen) {
        byte[] bs = new byte[arrayLen];
        for (int i = 0; i < arrayLen; i++) {
            int cary = i * 8;
            bs[arrayLen - i - 1] = (byte) ((value >> cary) & 0xFF);
        }
        return bs;
    }

    /**
     * 合并数组
     *
     * @param rest
     * @param
     * @return
     */
    public static byte[] concatAll(byte[]... rest) {
        if (rest.length == 0) {
            return new byte[0];
        } else if (rest.length == 1) {
            return rest[0];
        }
        int totalLength = 0;
        for (byte[] arr: rest) {
            totalLength += arr.length;
        }
        if (totalLength == 0) {
            return new byte[0];
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (byte[] array: rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }


}
