package com.vcarecity.gw.common.assembly.dtu;

import com.vcarecity.gw.common.assembly.IJsonDataAssembly;
import com.vcarecity.gw.common.exception.NoRequireKeyException;

import java.util.Map;

/**
 * @author Kerry on 18/04/17
 */

public interface IDtuJsonDataAssembly extends IJsonDataAssembly {
    /**
     * 返回当前所占的长度,如:0710 它后面所占数据长度,如果不确定返回-1
     * <p>
     * 不包函 0710 本身所占长度
     *
     * @return
     */
    int getCurrentCodeLength();


    /**
     * 组装DataItem
     *
     * @param data
     * @return
     * @throws NoRequireKeyException 当JSON数据不包函所需要的KEY时
     */
    byte[] assemblyDataItem(Map<String, Object> data) throws NoRequireKeyException;
}
