package com.vcarecity.gw.common.context;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/04/19
 * @JsonSerialize(using = ToStringSerializer.class) 是因为兼容以前的API...强行输出为String类型
 */

public class BaseJsonViewBean implements MessageContext {
    @JsonSerialize(using = ToStringSerializer.class)
    @JsonProperty("gatewayNo")
    private Integer gatewayNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @JsonProperty("protocolNo")
    private Integer protocolNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @JsonProperty("functionWord")
    private Integer functionWord;

    @JsonProperty("unitNo")
    private String unitNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @JsonProperty("equipmentNo")
    private Integer equipmentNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @JsonProperty("SN")
    private Integer sn;

    @JsonProperty("dataItems")
    private List<DataItemDTO> dataItems;

    @JsonSerialize(using = ToStringSerializer.class)
    @JsonProperty("enable")
    private Integer enable;


    public Integer getGatewayNo() {
        return gatewayNo;
    }

    public void setGatewayNo(Integer gatewayNo) {
        this.gatewayNo = gatewayNo;
    }

    public Integer getProtocolNo() {
        return protocolNo;
    }

    public void setProtocolNo(Integer protocolNo) {
        this.protocolNo = protocolNo;
    }

    public Integer getFunctionWord() {
        return functionWord;
    }

    public void setFunctionWord(Integer functionWord) {
        this.functionWord = functionWord;
    }

    public String getUnitNo() {
        return unitNo;
    }

    public void setUnitNo(String unitNo) {
        this.unitNo = unitNo;
    }

    public Integer getEquipmentNo() {
        return equipmentNo;
    }

    public void setEquipmentNo(Integer equipmentNo) {
        this.equipmentNo = equipmentNo;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public List<DataItemDTO> getDataItems() {
        return dataItems;
    }

    public void setDataItems(List<DataItemDTO> dataItems) {
        this.dataItems = dataItems;
    }

    public Integer getEnable() {
        return enable;
    }

    public void setEnable(Integer enable) {
        this.enable = enable;
    }

    public static class DataItemDTO {
        @JsonSerialize(using = ToStringSerializer.class)
        @JsonProperty("id")
        Integer id;

        @JsonProperty("data")
        Map<String, Object> data;


        public DataItemDTO() {
        }

        public DataItemDTO(Integer id, Map<String, Object> data) {
            this.id = id;
            this.data = data;
        }

        public Map<String, Object> getData() {
            return data;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public Integer getId() {
            return id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        @Override
        public String toString() {
            return "DataItemDTO{" +
                    "data=" + data +
                    ", id=" + id +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "BaseJsonViewBean{" +
                "gatewayNo=" + gatewayNo +
                ", protocolNo=" + protocolNo +
                ", functionWord=" + functionWord +
                ", unitNo='" + unitNo + '\'' +
                ", equipmentNo=" + equipmentNo +
                ", sn=" + sn +
                ", dataItems=" + dataItems +
                ", enable=" + enable +
                '}';
    }
}
