package com.vcarecity.gw.common.parser.dtu;



import com.vcarecity.gw.common.context.BaseJsonViewBean;
import com.vcarecity.gw.common.parser.IDataItemFrameParser;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/04/11
 */

public interface IDtuDataParser extends IDataItemFrameParser {
    /**
     * 返回当前所占的长度,如:0710 它后面所占数据长度,如果不确定返回-1
     * <p>
     * 不包函 0710 本身所占长度
     *
     * @return
     */
    int getCurrentCodeLength();

    /**
     * 组装数据
     *
     * @param dataType
     * @param data
     * @return
     */
    List<BaseJsonViewBean.DataItemDTO> parserDataItem(int dataType, byte[] data);

    /**
     * 当一个数据时,返回单个List
     *
     * @param dataType
     * @param data
     * @return
     */
    default List<BaseJsonViewBean.DataItemDTO> parserOneDataItem(Integer dataType, Map<String, Object> data) {
        return Collections.singletonList(new BaseJsonViewBean.DataItemDTO(dataType, data));
    }
}
