package com.vcarecity.gw.common.service;


import com.vcarecity.gw.common.context.MessageContext;
import com.vcarecity.gw.common.exception.NoRequireKeyException;

/**
 * @author Kerry on 18/04/13
 * <p>
 * json to byte[]
 */

public interface IAssemblyService {
    /**
     * JSON数据组装成数据帧
     *
     * @param messageContext
     * @return
     * @throws NoRequireKeyException 当JSON中缺少需要的KEY
     */
    byte[] assembly(MessageContext messageContext) throws NoRequireKeyException;

    /**
     * JSON数据组装成数据帧
     *
     * @param messageContext
     * @return
     * @throws NoRequireKeyException 当JSON中缺少需要的KEY
     */
    String assemblyHex(MessageContext messageContext) throws NoRequireKeyException;
}