package com.vcarecity.gw.common.util;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

import java.util.Arrays;

/**
 * @author Kerry on 18/04/09
 * @since 2018年4月16日9:58:55
 */

public final class AnyUtil {


    /**
     * 字符串转换成特定长度的byte[]
     *
     * @param str
     * @param len
     * @return
     */
    public static byte[] strToByte(String str, int len) {
        if (str == null) {
            return new byte[len];
        }
        byte[] result = str.getBytes();
        int cLen = result.length;
        if (cLen == len) {
            return result;
        } else if (result.length > len) {
            return Arrays.copyOfRange(result, cLen - len, cLen);
        } else {
            byte[] res = new byte[len];
            System.arraycopy(result, 0, res, len - cLen, cLen);
            return res;
        }
    }


    public static byte[] hexToByte(String hex) {
        if (hex == null) {
            return new byte[0];
        }
        try {
            return Hex.decodeHex(hex);
        } catch (DecoderException e) {
            e.printStackTrace();
        }
        return new byte[0];
    }

    /**
     * 16进制字符串转换成特定长度的byte[]数组
     *
     * @param hex
     * @param len
     * @return
     */
    public static byte[] hexToByte(String hex, int len) {
        if (hex == null) {
            return new byte[len];
        }

        byte[] decodeResult = null;
        try {
            decodeResult = Hex.decodeHex(hex);
        } catch (DecoderException e) {
            e.printStackTrace();
        }
        if (decodeResult == null) {
            return new byte[len];
        } else if (decodeResult.length == len) {
            return decodeResult;
        } else if (decodeResult.length > len) {
            //长度太长,取后面的..
            return Arrays.copyOfRange(decodeResult, decodeResult.length - len, decodeResult.length);
        } else {
            //太短
            byte[] res = new byte[len];
            int i = (len - decodeResult.length);
            System.arraycopy(decodeResult, 0, res, i, len - i);
            return res;
        }
    }


    /**
     * 10进制的字符器Object
     *
     * @param decObject
     * @param len
     * @return
     */
    public static byte[] intToByte(Object decObject, int len) {
        if (decObject == null) {
            return new byte[len];
        }
        return intToByte(Integer.parseInt(decObject.toString()), len);
    }

    public static byte[] intToByte(int value, int length) {
        byte[] b = new byte[length];
        for (int k = 0; k < length; k++) {
            b[length - k - 1] = (byte) ((value >> 8 * k) & 0xff);
        }
        return b;
    }

    /**
     * 合并数组
     *
     * @param rest
     * @param
     * @return
     */
    public static byte[] concatAll(byte[]... rest) {

        byte[] first = new byte[0];

        int totalLength = first.length;
        for (byte[] array : rest) {
            totalLength += array.length;
        }
        byte[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (byte[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static int byteArrayToInt(byte[] data) {
        if (data == null || data.length < 1 || data.length > 4) {
            return -1;
        }
        int result = 0;
        int len = data.length;
        for (int i = 0; i < len; i++) {
            int ch = byteArrayToInt(data[len - 1 - i]);

            result += ch << (8 * i);
        }
        if (data.length == 1 && result < 0) {
            result += 256;
        }
        return result;
    }

    public static int byteArrayToInt(byte data) {
        return (data & 0xff);
    }

}
