package com.vcarecity.telnb.constant;

/**
 * @author Kerry on 18/11/07
 */

public final class TelUrlConstant {
    /**
     * AUTH
     */
    public static final String APP_AUTH = "/iocm/app/sec/v1.1.0/login";
    public static final String REFRESH_TOKEN = "/iocm/app/sec/v1.1.0/refreshToken";


    /**
     * 注册设备
     */
    public static final String REGISTER_DEVICE = "iocm/app/reg/v1.1.0/deviceCredentials?appId={appId}";

    /**
     * 查询设备激活状态
     */
    public static final String QUERY_DEVICE_ACTIVE_STATUS = "/iocm/app/reg/v1.1.0/deviceCredentials/{deviceId}?appId={appId}";

    /**
     * 删除直连设备
     */
    public static final String DELETE_DEVICE = "/iocm/app/dm/v1.4.0/devices/{deviceId}?appId={appId}&cascade={cascade}";

    /**
     * 修改设备信息
     */
    public static final String UPDATE_DEVICE_INFO = "/iocm/app/dm/v1.4.0/devices/{deviceId}?appId={appId}";


    public static final String REFRESH_DEVICE_KEY = "/iocm/app/reg/v1.1.0/deviceCredentials/{deviceId}?appId={appId}";


    /**
     * 查询单个设备信息
     */
    public static final String QUERY_DEVICE_INFO = "/iocm/app/dm/v1.4.0/devices/{deviceId}?appId={appId}&select={select}";


    /**
     * Application 订阅平台数据
     */
    public static final String APP_SUB_PLATFORM_DATA = "/iocm/app/sub/v1.1.0/subscribe";


    public static final String QUERY_DEVICE_HISTORY_DATA = "/iocm/app/data/v1.1.0/deviceDataHistory";
    public static final String QUERY_DEVICE_ABILITY = "/iocm/app/data/v1.1.0/deviceCapabilities";


    //------------------------信令传送--------------------------

    /**
     * 创建设备命令
     */
    public static final String CREATE_DEVICE_CMD = "/iocm/app/cmd/v1.4.0/deviceCommands";

    /**
     * 查询设备命令
     */
    public static final String QUERY_DEVICE_CMD = "/iocm/app/cmd/v1.4.0/deviceCommands?pageNo={pageNo}&pageSize={pageSize}&deviceId={deviceId}&startTime={startTime}&endTime={endTime}&appId={appId}";


    /**
     * 修改设备命令
     */
    public static final String UPDATE_DEVICE_CMD = "/iocm/app/cmd/v1.4.0/deviceCommands/%s";


    public static final String CREATE_DEVICE_CMD_CANCEL_TASK = "/iocm/app/cmd/v1.4.0/deviceCommandCancelTasks";


    /**
     * 订阅平台业务数据
     */
    public static final String SUBSCRIBE_PLATFORM_BUSINESS_DATA = "/iocm/app/sub/v1.2.0/subscriptions?ownerFlag={ownerFlag}";

    /**
     * 删除单个订阅
     */
    public static final String DELETE_SUBSCRIBE = "/iocm/app/sub/v1.2.0/subscriptions/{subscriptionId}?appId={appId}";

    /**
     * 批量查询订阅
     */
    public static final String BATCH_QUERY_SUBSCRIBE = "/iocm/app/sub/v1.2.0/subscriptions?appId={appId}&notifyType={notifyType}&pageNo={pageNo}&pageSize={pageSize}";

}
