package com.vcarecity.telnb.core;

import org.jetbrains.annotations.Nullable;

import java.util.concurrent.TimeUnit;

/**
 * @author Kerry on 18/11/07
 */

public interface CacheTemplate {

    /**
     * 通过类型返回
     *
     * @param key
     * @param clazz
     * @param <T>
     * @return
     */
    @Nullable <T> T get(String key, Class<T> clazz);

    /**
     * 默认字符串类型
     *
     * @param key
     * @return
     */
    @Nullable
    default String get(String key) {
        return get(key, String.class);
    }

    /**
     * 设置
     *
     * @param key
     * @param value
     * @param clazz
     * @param expireIn
     * @param timeUnit
     * @param <T>
     */
    <T> void set(String key, Object value, Class<T> clazz, Long expireIn, TimeUnit timeUnit);

    /**
     * 设置
     *
     * @param key
     * @param value
     * @param expireInSecond
     */
    default void set(String key, Object value, Long expireInSecond) {
        set(key, value, String.class, expireInSecond, TimeUnit.SECONDS);
    }

    /**
     * 获取Key的剩余时间
     *
     * @param key
     * @param timeUnit
     * @return
     */
    @Nullable
    Long getExpire(String key, TimeUnit timeUnit);

    /**
     * 获取Key的剩余时间,这里返回:秒
     *
     * @param key
     * @return
     */
    @Nullable
    default Long getExpire(String key) {
        return getExpire(key, TimeUnit.SECONDS);
    }


    /**
     * 删除
     *
     * @param key
     */
    void remove(String key);

}
