package com.vcarecity.telnb.dto;

import com.vcarecity.telnb.context.IResponseDataContext;

import java.util.List;

/**
 * @author Kerry on 18/10/23
 */

public class SubscribeBatchQueryResponseDTO implements IResponseDataContext {

    private Long totalCount;
    private Long pageNo;
    private Long pageSize;
    private List<SubscriptionDTO> subscriptions;

    public Long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public Long getPageNo() {
        return pageNo;
    }

    public void setPageNo(Long pageNo) {
        this.pageNo = pageNo;
    }

    public Long getPageSize() {
        return pageSize;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public List<SubscriptionDTO> getSubscriptions() {
        return subscriptions;
    }

    public void setSubscriptions(List<SubscriptionDTO> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Override
    public String toString() {
        return "SubscribeBatchQueryResponseDTO{" +
                "totalCount=" + totalCount +
                ", pageNo=" + pageNo +
                ", pageSize=" + pageSize +
                ", subscriptions=" + subscriptions +
                '}';
    }

    public static class SubscriptionDTO {
        private String subscriptionId;
        private String notifyType;
        private String callbackUrl;

        public String getSubscriptionId() {
            return subscriptionId;
        }

        public void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        public String getNotifyType() {
            return notifyType;
        }

        public void setNotifyType(String notifyType) {
            this.notifyType = notifyType;
        }

        public String getCallbackUrl() {
            return callbackUrl;
        }

        public void setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
        }

        @Override
        public String toString() {
            return "SubscriptionDTO{" +
                    "subscriptionId='" + subscriptionId + '\'' +
                    ", notifyType='" + notifyType + '\'' +
                    ", callbackUrl='" + callbackUrl + '\'' +
                    '}';
        }
    }

}
