package com.vcarecity.telnb.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Kerry on 18/10/22
 */

public class UpdateDeviceInfoRequestDTO {
    private String name;
    private String endUser;
    private String mute;
    private String manufacturerId;
    private String manufacturerName;
    private String deviceType;
    private String model;
    private String location;
    private String protocolType;
    @JsonProperty("deviceConfig")
    private DeviceConfigEntity deviceConfig;
    private String region;
    private String organization;
    private String timezone;
    private Boolean isSecure;
    private String psk;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEndUser() {
        return endUser;
    }

    public void setEndUser(String endUser) {
        this.endUser = endUser;
    }

    public String getMute() {
        return mute;
    }

    public void setMute(String mute) {
        this.mute = mute;
    }

    public String getManufacturerId() {
        return manufacturerId;
    }

    public void setManufacturerId(String manufacturerId) {
        this.manufacturerId = manufacturerId;
    }

    public String getManufacturerName() {
        return manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getProtocolType() {
        return protocolType;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public DeviceConfigEntity getDeviceConfig() {
        return deviceConfig;
    }

    public void setDeviceConfig(DeviceConfigEntity deviceConfig) {
        this.deviceConfig = deviceConfig;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getOrganization() {
        return organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public Boolean getSecure() {
        return isSecure;
    }

    public void setSecure(Boolean secure) {
        isSecure = secure;
    }

    public String getPsk() {
        return psk;
    }

    public void setPsk(String psk) {
        this.psk = psk;
    }

    public class DeviceConfigEntity {
        @JsonProperty("dataConfig")
        private DataConfigEntity dataConfig;

        public DataConfigEntity getDataConfig() {
            return dataConfig;
        }

        public void setDataConfig(DataConfigEntity dataConfig) {
            this.dataConfig = dataConfig;
        }

        @Override
        public String toString() {
            return "DeviceConfigEntity{" +
                    "dataConfig=" + dataConfig +
                    '}';
        }

        public class DataConfigEntity {
            @JsonProperty("dataAgingTime")
            private Integer dataAgingTime;

            public void setDataAgingTime(Integer dataAgingTime) {
                this.dataAgingTime = dataAgingTime;
            }

            public Integer getDataAgingTime() {
                return dataAgingTime;
            }

            @Override
            public String toString() {
                return "DataConfigEntity{" +
                        "dataAgingTime=" + dataAgingTime +
                        '}';
            }
        }
    }

    @Override
    public String toString() {
        return "UpdateDeviceInfoRequestDTO{" +
                "name='" + name + '\'' +
                ", endUser='" + endUser + '\'' +
                ", mute='" + mute + '\'' +
                ", manufacturerId='" + manufacturerId + '\'' +
                ", manufacturerName='" + manufacturerName + '\'' +
                ", deviceType='" + deviceType + '\'' +
                ", model='" + model + '\'' +
                ", location='" + location + '\'' +
                ", protocolType='" + protocolType + '\'' +
                ", deviceConfig=" + deviceConfig +
                ", region='" + region + '\'' +
                ", organization='" + organization + '\'' +
                ", timezone='" + timezone + '\'' +
                ", isSecure=" + isSecure +
                ", psk='" + psk + '\'' +
                '}';
    }
}
