package com.vcarecity.telnb.properties;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author Kerry on 18/11/07
 */


@ConditionalOnMissingBean
@ConfigurationProperties(prefix = "tel.nb")
public class TelNbProperties {
    private Boolean enable = true;
    private String keySpace = "tel:nb";
    /**
     * default 1 month
     */
    private Integer refreshTokenExpire = 2592000;
    private String appName;
    private String model;
    private String manufacturerId;
    private String manufacturerName;
    private String deviceType;
    private String appId;
    private String secret;
    private String apiUrl;
    private String commandRespUrl;

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getKeySpace() {
        return keySpace;
    }

    public void setKeySpace(String keySpace) {
        this.keySpace = keySpace;
    }

    public Integer getRefreshTokenExpire() {
        return refreshTokenExpire;
    }

    public void setRefreshTokenExpire(Integer refreshTokenExpire) {
        this.refreshTokenExpire = refreshTokenExpire;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getManufacturerId() {
        return manufacturerId;
    }

    public void setManufacturerId(String manufacturerId) {
        this.manufacturerId = manufacturerId;
    }

    public String getManufacturerName() {
        return manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getCommandRespUrl() {
        return commandRespUrl;
    }

    public void setCommandRespUrl(String commandRespUrl) {
        this.commandRespUrl = commandRespUrl;
    }
}
