package com.vcarecity.telnb.provider;

import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

/**
 * @author KerryZhang 电信NB的HttpHeader
 */
public interface HeaderProvider {

    /**
     * 一般Header
     *
     * @return
     */
    HttpHeaders getHttpHeaders();


    /**
     * 指定Header
     *
     * @param mediaType
     * @return
     */
    default HttpHeaders getReqHeader(MediaType mediaType) {
        HttpHeaders httpHeaders = getHttpHeaders();
        httpHeaders.setContentType(mediaType);
        return httpHeaders;
    }


    /**
     * application/json/charset=utf8
     *
     * @return
     */
    default HttpHeaders getAppJsonUtf8Header() {
        HttpHeaders httpHeaders = getHttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return httpHeaders;
    }

    /**
     * application/json
     *
     * @return
     */
    default HttpHeaders getAppJsonHeader() {
        HttpHeaders httpHeaders = getHttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        return httpHeaders;
    }

}
