package com.vcarecity.telnb.service;

import org.springframework.http.ResponseEntity;

/**
 * @author Kerry
 * <p>
 * 认证服务
 */

public interface AuthService {

    /**
     * 请求新的Token
     *
     * @param appId
     * @param secret
     * @return 刚刚请求的Token
     */
    ResponseEntity<String> requestToken(String appId, String secret);


    /**
     * 刷新Token
     *
     * @param appId
     * @param secret
     * @param refreshToken
     * @return 返回最新的Token
     */
    ResponseEntity<String> refreshToken(String appId, String secret, String refreshToken);


}
