package com.vcarecity.telnb.service;

import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.CreateDeviceCmdRequestDTO;
import org.jetbrains.annotations.NotNull;

/**
 * @author Kerry on 18/10/22
 * <p>
 * 命令下发
 *
 *
 * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
 * 命令下发
 * </a>
 */

public interface DownStreamService {


    /**
     * 创建设备命令
     *
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 创建设备命令
     * </a>
     *
     * @param createDeviceCmd
     * @return
     * @throws Exception
     */
    AbstractResponse createDeviceCmd(CreateDeviceCmdRequestDTO createDeviceCmd) throws Exception;


    /**
     * 查询设备命令
     *
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 查询设备命令
     * </a>
     *
     * @param deviceId
     * @param pageNo
     * @param pageSize
     * @param startTime
     * @param endTime
     * @return
     */
    AbstractResponse queryDeviceCmd(@NotNull String deviceId, Integer pageNo, Integer pageSize, String startTime, String endTime);

}
