package com.vcarecity.telnb.service;

import com.vcarecity.telnb.api.AddDeviceBean;
import com.vcarecity.telnb.core.AbstractResponse;
import org.jetbrains.annotations.NotNull;

/**
 * @author Kerry on 18/11/07
 */

public interface NbDeviceApiService {
    /**
     * 添加设备
     *
     * @param device
     * @return
     * @throws Exception
     */
    AbstractResponse addDevice(AddDeviceBean device) throws Exception;

    /**
     * 删除设备
     *
     * @param deviceId
     * @return
     */
    AbstractResponse deleteDeviceById(@NotNull String deviceId);

    /**
     * 查询设备信息
     *
     * @param deviceId
     * @return
     */
    AbstractResponse queryDeviceInfo(@NotNull String deviceId);
}
