package com.vcarecity.telnb.service;

import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.SubscribeRequestDTO;

/**
 * @author Kerry on 18/10/22
 */

public interface SubscribeManagerService {


    /**
     * 订阅平台业务数据
     *
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 订阅平台业务数据
     * </a>
     *
     * @param subscribe
     * @param ownerFlag
     * @return
     * @throws Exception
     */
    AbstractResponse subscribePlatformBusinessData(SubscribeRequestDTO subscribe, String ownerFlag) throws Exception;


    /**
     * 删除单个订阅
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 删除单个订阅
     * </a>
     *
     * @param subscriptionId
     * @return
     */
    AbstractResponse deleteSubscribe(String subscriptionId);


    /**
     * 批量查询订阅
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 批量查询订阅
     * </a>
     *
     * @param notifyType
     * @param pageNo
     * @param pageSize
     * @return
     */
    AbstractResponse batchQuerySubscribe(SubscribeRequestDTO.NotifyType notifyType, Integer pageNo, Integer pageSize);

}
