package com.vcarecity.telnb.service;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Kerry on 18/11/07
 * <p>
 * Token相关
 */

public interface TokenService {
    /**
     * 通过ID获取Token
     *
     * @return
     */
    @Nullable
    String getAccessToken();

    /**
     * 获取RefreshToken
     *
     * @return
     */
    @Nullable
    String getRefreshToken();


    /**
     * 更新AccessToken 通过RefreshToken
     *
     * @return
     */
    String refreshAccessToken();


    /**
     * 获取RefreshToken剩余时间
     *
     * @return 单位:秒
     */
    @NotNull
    Long getRefreshTokenExpiresSecond();

    /**
     * 获取AccessToken剩余时间
     *
     * @return 单位:秒
     */
    @NotNull
    Long getAccessTokenExpiresSecond();


    /**
     * 获取Token最后更新的时间戳
     *
     * @return
     */
    Long getTokenLastUpdateTime();


    /**
     * 更新最后Token时间
     */
    void updateTokenLastTime();

    /**
     * 获取Scope
     *
     * @return
     */
    String getScope();

    /**
     * 获取TokenType
     *
     * @return
     */
    String getTokenType();
}
