package com.vcarecity.telnb.service.impl;

import com.vcarecity.telnb.constant.NbConstant;
import com.vcarecity.telnb.constant.TelUrlConstant;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.QueryDeviceInfoResponseDTO;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.provider.HeaderProvider;
import com.vcarecity.telnb.service.DataCollectService;
import com.vcarecity.telnb.util.ResponseHandleUtil;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * @author KerryZhang
 */
@Service
@ConditionalOnProperty(value = "tel.nb.enable")
public class DataCollectServiceImpl implements DataCollectService {

    private final RestTemplate restTemplate;
    private final HeaderProvider headerProvider;

    private final TelNbProperties telNbProperties;

    public DataCollectServiceImpl(RestTemplate restTemplate,
                                  HeaderProvider headerProvider,
                                  TelNbProperties telNbProperties) {
        this.restTemplate = restTemplate;
        this.headerProvider = headerProvider;
        this.telNbProperties = telNbProperties;
    }

    @Override
    public AbstractResponse queryDeviceInfo(@NotNull String deviceId, String select) {

        Map<String, Object> uris = new HashMap<>(4);
        uris.put(NbConstant.KEY_4_APP_ID, telNbProperties.getAppId());
        uris.put("deviceId", deviceId);
        uris.put("select", select);

        HttpEntity<String> entity = new HttpEntity<>(headerProvider.getAppJsonHeader());
        ResponseEntity<String> response = restTemplate.exchange(TelUrlConstant.QUERY_DEVICE_INFO, HttpMethod.GET, entity, String.class, uris);

        return ResponseHandleUtil.responseDataHandler(response, QueryDeviceInfoResponseDTO.class);
    }


}