package com.vcarecity.telnb.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.telnb.constant.NbConstant;
import com.vcarecity.telnb.constant.TelUrlConstant;
import com.vcarecity.telnb.context.IResponseDataContext;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.SubscribeBatchQueryResponseDTO;
import com.vcarecity.telnb.dto.SubscribeRequestDTO;
import com.vcarecity.telnb.dto.SubscribeResponseDTO;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.provider.HeaderProvider;
import com.vcarecity.telnb.service.SubscribeManagerService;
import com.vcarecity.telnb.util.ResponseHandleUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/10/22
 */

@Service
@ConditionalOnProperty(value = "tel.nb.enable")
public class SubscribeManagerServiceImpl implements SubscribeManagerService {

    private final RestTemplate restTemplate;
    private final HeaderProvider headerProvider;
    private final ObjectMapper objectMapper;
    private final TelNbProperties telNbProperties;

    public SubscribeManagerServiceImpl(RestTemplate restTemplate, HeaderProvider headerProvider, ObjectMapper objectMapper, TelNbProperties telNbProperties) {
        this.restTemplate = restTemplate;
        this.headerProvider = headerProvider;
        this.objectMapper = objectMapper;
        this.telNbProperties = telNbProperties;
    }


    @Override
    public AbstractResponse subscribePlatformBusinessData(SubscribeRequestDTO subscribe, String ownerFlag) throws Exception {
        final String value = objectMapper.writeValueAsString(subscribe);

        HttpEntity<String> entity = new HttpEntity<>(value, headerProvider.getAppJsonHeader());
        final Map<String, String> map = Collections.singletonMap("ownerFlag", ownerFlag);

        ResponseEntity<String> response = restTemplate.postForEntity(TelUrlConstant.SUBSCRIBE_PLATFORM_BUSINESS_DATA, entity, String.class, map);

        return ResponseHandleUtil.responseDataHandler(response, SubscribeResponseDTO.class);
    }

    @Override
    public AbstractResponse deleteSubscribe(String subscriptionId) {

        Map<String, String> uri = new HashMap<>(4);
        uri.put(NbConstant.KEY_4_APP_ID, telNbProperties.getAppId());
        uri.put("subscriptionId", subscriptionId);
        HttpEntity<String> entity = new HttpEntity<>(headerProvider.getHttpHeaders());

        ResponseEntity<String> response = restTemplate.exchange(TelUrlConstant.DELETE_SUBSCRIBE, HttpMethod.DELETE, entity, String.class, uri);

        return ResponseHandleUtil.responseDataHandler(response, IResponseDataContext.class);
    }

    @Override
    public AbstractResponse batchQuerySubscribe(SubscribeRequestDTO.NotifyType notifyType, Integer pageNo, Integer pageSize) {


        Map<String, Object> uri = new HashMap<>(4);
        uri.put(NbConstant.KEY_4_APP_ID, telNbProperties.getAppId());
        if (notifyType != null) {
            uri.put("notifyType", notifyType.getName());
        } else {
            uri.put("notifyType", "");
        }
        uri.put("pageNo", pageNo);
        uri.put("pageSize", pageSize);
        HttpEntity<String> entity = new HttpEntity<>(headerProvider.getHttpHeaders());

        ResponseEntity<String> response = restTemplate.exchange(TelUrlConstant.BATCH_QUERY_SUBSCRIBE, HttpMethod.GET, entity, String.class, uri);

        return ResponseHandleUtil.responseDataHandler(response, SubscribeBatchQueryResponseDTO.class);
    }
}
