package com.vcarecity.telnb.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.telnb.constant.CusHttpCode;
import com.vcarecity.telnb.constant.NbConstant;
import com.vcarecity.telnb.context.IResponseDataContext;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.core.DataResponse;
import com.vcarecity.telnb.core.ErrorResponse;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

import java.io.IOException;

/**
 * @author KerryZhang
 * 响应体转换
 */
public final class ResponseHandleUtil {

    private static ObjectMapper objectMapper;

    public static AbstractResponse newErrorResponse(int httpCode, int status, String message) {
        DataResponse<IResponseDataContext> dataResponse = new DataResponse<>();
        dataResponse.setHttpCode(httpCode);
        dataResponse.setStatus(status);
        dataResponse.setMessage(message);
        return dataResponse;
    }


    @NotNull
    public static AbstractResponse responseDataHandler(ResponseEntity<String> response, Class<? extends IResponseDataContext> responseDataClazz) {
        if (objectMapper == null) {
            synchronized (ResponseHandleUtil.class) {
                if (objectMapper == null) {
                    objectMapper = new ObjectMapper();
                    objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                }
            }
        }

        if (response.getStatusCode() == HttpStatus.NO_CONTENT) {
            DataResponse<IResponseDataContext> dataResponse = new DataResponse<>();
            dataResponse.setStatus(CusHttpCode.SUCCESS);
            dataResponse.setHttpCode(HttpStatus.NO_CONTENT.value());
            dataResponse.setStatus(CusHttpCode.SUCCESS);
            return dataResponse;
        }

        final String body = response.getBody();
        JsonNode node;
        try {
            node = objectMapper.readTree(body);
        } catch (IOException e) {
            e.printStackTrace();
            return newErrorResponse(response.getStatusCodeValue(), CusHttpCode.DATA_EXCEPTION, e.getMessage());
        }

        JsonNode errorCode = node.get(NbConstant.ERROR_CODE);
        JsonNode errorDesp = node.get(NbConstant.ERROR_DESC);
        if (errorCode != null) {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setHttpCode(response.getStatusCodeValue());
            errorResponse.setErrorCode(errorCode.asInt());
            errorResponse.setErrorDesc(errorDesp != null ? errorDesp.textValue() : null);
            return errorResponse;
        }

        DataResponse<IResponseDataContext> dataResponse = new DataResponse<>();
        dataResponse.setHttpCode(response.getStatusCodeValue());
        try {
            IResponseDataContext dataContext = objectMapper.readValue(body, responseDataClazz);
            dataResponse.setData(dataContext);
            dataResponse.setStatus(CusHttpCode.SUCCESS);
        } catch (IOException e) {
            e.printStackTrace();
            dataResponse.setMessage(e.getMessage());
            dataResponse.setStatus(CusHttpCode.DATA_EXCEPTION);
        }
        return dataResponse;
    }

}