/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.telnb.core;

import com.vcarecity.telnb.core.CacheTemplate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheTemplate
implements CacheTemplate {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCacheTemplate.class);
    private final Map<String, Object> cacheData = new ConcurrentHashMap<String, Object>(16);
    private final Map<String, Long> cacheTime = new ConcurrentHashMap<String, Long>(16);

    public DefaultCacheTemplate() {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        Runnable runnable = () -> {
            Set<String> strings = this.cacheData.keySet();
            HashSet expireKey = new HashSet();
            strings.forEach(key -> {
                Long aLong = this.cacheTime.get(key);
                if (aLong == null) {
                    expireKey.add(key);
                } else if (System.currentTimeMillis() / 1000L - aLong > 0L) {
                    expireKey.add(key);
                }
            });
            expireKey.forEach(this.cacheData::remove);
        };
        service.scheduleAtFixedRate(runnable, 10L, 180L, TimeUnit.SECONDS);
    }

    @Override
    @Nullable
    public <T> T get(String key, Class<T> clazz) {
        Long lastTime = this.cacheTime.get(key);
        if (lastTime == null) {
            this.cacheData.remove(key);
            return null;
        }
        if (System.currentTimeMillis() / 1000L - lastTime > 0L) {
            this.cacheTime.remove(key);
            this.cacheData.remove(key);
            return null;
        }
        Object o = this.cacheData.get(key);
        if (o == null) {
            this.cacheTime.remove(key);
            return null;
        }
        return (T)o;
    }

    @Override
    public <T> void set(String key, Object value, Class<T> clazz, Long expireIn, TimeUnit timeUnit) {
        this.cacheData.put(key, value);
        long time = System.currentTimeMillis();
        time = expireIn == null ? (time += 600L) : (time += expireIn.longValue());
        this.cacheTime.put(key, timeUnit.toSeconds(time));
    }

    @Override
    @Nullable
    public Long getExpire(String key, TimeUnit timeUnit) {
        Object o = this.cacheData.get(key);
        if (o == null) {
            this.cacheTime.remove(key);
            return null;
        }
        Long aLong = this.cacheTime.get(key);
        if (aLong == null) {
            return null;
        }
        return timeUnit.convert(aLong, TimeUnit.SECONDS);
    }

    @Override
    public void remove(String key) {
        this.cacheData.remove(key);
        this.cacheTime.remove(key);
    }
}

