/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.telnb.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.telnb.service.AuthService;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnProperty(value={"tel.nb.enable"})
public class AuthServiceImpl
implements AuthService {
    private static final Logger logger = LoggerFactory.getLogger(AuthServiceImpl.class);
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    @Autowired
    public AuthServiceImpl(RestTemplate restTemplate, ObjectMapper objectMapper) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    @Override
    public ResponseEntity<String> requestToken(String appId, String secret) {
        logger.debug("AuthServiceImpl.requestToken. Get Token by appId = {} and secret", (Object)appId);
        LinkedMultiValueMap httpBody = new LinkedMultiValueMap();
        httpBody.add((Object)"appId", (Object)appId);
        httpBody.add((Object)"secret", (Object)secret);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)httpBody, (MultiValueMap)httpHeaders);
        return this.restTemplate.postForEntity("/iocm/app/sec/v1.1.0/login", (Object)request, String.class, new Object[0]);
    }

    @Override
    public ResponseEntity<String> refreshToken(String appId, String secret, String refreshToken) {
        String body;
        if (refreshToken == null) {
            logger.debug("AuthServiceImpl.refreshToken. refreshToken is null or expire");
            return this.requestToken(appId, secret);
        }
        logger.debug("refreshToken. model = {}. refreshToken = {}", (Object)refreshToken);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        httpHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON_UTF8));
        LinkedHashMap<String, String> httpBody = new LinkedHashMap<String, String>();
        httpBody.put("appId", appId);
        httpBody.put("secret", secret);
        httpBody.put("refreshToken", refreshToken);
        try {
            body = this.objectMapper.writeValueAsString(httpBody);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity("/iocm/app/sec/v1.1.0/refreshToken", (Object)request, String.class, new Object[0]);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                return responseEntity;
            }
        }
        catch (RuntimeException re) {
            logger.error(re.getMessage(), (Throwable)re);
            re.printStackTrace();
        }
        return this.requestToken(appId, secret);
    }
}

