/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.telnb.service.impl;

import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.QueryDeviceInfoResponseDTO;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.provider.HeaderProvider;
import com.vcarecity.telnb.service.DataCollectService;
import com.vcarecity.telnb.util.ResponseHandleUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnProperty(value={"tel.nb.enable"})
public class DataCollectServiceImpl
implements DataCollectService {
    private final RestTemplate restTemplate;
    private final HeaderProvider headerProvider;
    private final TelNbProperties telNbProperties;

    public DataCollectServiceImpl(RestTemplate restTemplate, HeaderProvider headerProvider, TelNbProperties telNbProperties) {
        this.restTemplate = restTemplate;
        this.headerProvider = headerProvider;
        this.telNbProperties = telNbProperties;
    }

    @Override
    public AbstractResponse queryDeviceInfo(@NotNull String deviceId, String select) {
        HashMap<String, String> uris = new HashMap<String, String>(4);
        uris.put("appId", this.telNbProperties.getAppId());
        uris.put("deviceId", deviceId);
        uris.put("select", select);
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headerProvider.getAppJsonHeader());
        ResponseEntity response = this.restTemplate.exchange("/iocm/app/dm/v1.4.0/devices/{deviceId}?appId={appId}&select={select}", HttpMethod.GET, entity, String.class, uris);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, QueryDeviceInfoResponseDTO.class);
    }
}

