/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.telnb.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.telnb.context.IResponseDataContext;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.QueryDeviceActiveStatusResponseDTO;
import com.vcarecity.telnb.dto.RefreshDeviceKeyRequestDTO;
import com.vcarecity.telnb.dto.RefreshDeviceKeyResponseDTO;
import com.vcarecity.telnb.dto.RegisteredDeviceRequestDTO;
import com.vcarecity.telnb.dto.RegisteredDeviceResponseDTO;
import com.vcarecity.telnb.dto.UpdateDeviceInfoRequestDTO;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.provider.HeaderProvider;
import com.vcarecity.telnb.service.DeviceManagerService;
import com.vcarecity.telnb.util.ResponseHandleUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnProperty(value={"tel.nb.enable"})
public class DeviceManagerServiceImpl
implements DeviceManagerService {
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final HeaderProvider headerProvider;
    private final TelNbProperties telNbProperties;

    public DeviceManagerServiceImpl(RestTemplate restTemplate, ObjectMapper objectMapper, HeaderProvider headerProvider, TelNbProperties telNbProperties) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.headerProvider = headerProvider;
        this.telNbProperties = telNbProperties;
    }

    @Override
    public AbstractResponse registeredDevice(RegisteredDeviceRequestDTO registeredDevice) throws Exception {
        String value = this.objectMapper.writeValueAsString((Object)registeredDevice);
        HttpHeaders reqHeader = this.headerProvider.getReqHeader(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity entity = new HttpEntity((Object)value, (MultiValueMap)reqHeader);
        Map<String, String> uri = Collections.singletonMap("appId", this.telNbProperties.getAppId());
        ResponseEntity response = this.restTemplate.postForEntity("iocm/app/reg/v1.1.0/deviceCredentials?appId={appId}", (Object)entity, String.class, uri);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, RegisteredDeviceResponseDTO.class);
    }

    @Override
    public AbstractResponse updateDeviceInfo(@NotNull String deviceId, UpdateDeviceInfoRequestDTO updateDeviceInfo) throws Exception {
        String value = this.objectMapper.writeValueAsString((Object)updateDeviceInfo);
        HttpHeaders reqHeader = this.headerProvider.getAppJsonHeader();
        HttpEntity entity = new HttpEntity((Object)value, (MultiValueMap)reqHeader);
        HashMap<String, String> uris = new HashMap<String, String>(4);
        uris.put("appId", this.telNbProperties.getAppId());
        uris.put("deviceId", deviceId);
        ResponseEntity response = this.restTemplate.exchange("/iocm/app/dm/v1.4.0/devices/{deviceId}?appId={appId}", HttpMethod.PUT, entity, String.class, uris);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, IResponseDataContext.class);
    }

    @Override
    public AbstractResponse deleteDevice(@NotNull String deviceId, @Nullable String cascade) {
        HashMap<String, String> uris = new HashMap<String, String>(4);
        uris.put("appId", this.telNbProperties.getAppId());
        uris.put("deviceId", deviceId);
        uris.put("cascade", cascade);
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headerProvider.getAppJsonHeader());
        ResponseEntity response = this.restTemplate.exchange("/iocm/app/dm/v1.4.0/devices/{deviceId}?appId={appId}&cascade={cascade}", HttpMethod.DELETE, entity, String.class, uris);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, IResponseDataContext.class);
    }

    @Override
    public AbstractResponse queryDeviceActiveStatus(@NotNull String deviceId) {
        HashMap<String, String> uris = new HashMap<String, String>(4);
        uris.put("appId", this.telNbProperties.getAppId());
        uris.put("deviceId", deviceId);
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headerProvider.getAppJsonHeader());
        ResponseEntity response = this.restTemplate.exchange("/iocm/app/reg/v1.1.0/deviceCredentials/{deviceId}?appId={appId}", HttpMethod.GET, entity, String.class, uris);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, QueryDeviceActiveStatusResponseDTO.class);
    }

    @Override
    public AbstractResponse refreshDeviceKey(String deviceId, RefreshDeviceKeyRequestDTO refreshDeviceKey) throws Exception {
        String value = this.objectMapper.writeValueAsString((Object)refreshDeviceKey);
        HttpEntity entity = new HttpEntity((Object)value, (MultiValueMap)this.headerProvider.getAppJsonHeader());
        HashMap<String, String> uris = new HashMap<String, String>(4);
        uris.put("appId", this.telNbProperties.getAppId());
        uris.put("deviceId", deviceId);
        ResponseEntity response = this.restTemplate.postForEntity("iocm/app/reg/v1.1.0/deviceCredentials?appId={appId}", (Object)entity, String.class, uris);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, RefreshDeviceKeyResponseDTO.class);
    }
}

