/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.telnb.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.CreateDeviceCmdRequestDTO;
import com.vcarecity.telnb.dto.CreateDeviceCmdResponseDTO;
import com.vcarecity.telnb.dto.QueryDeviceCmdResponseDTO;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.provider.HeaderProvider;
import com.vcarecity.telnb.service.DownStreamService;
import com.vcarecity.telnb.util.ResponseHandleUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnProperty(value={"tel.nb.enable"})
public class DownStreamServiceImpl
implements DownStreamService {
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final HeaderProvider headerProvider;
    private final TelNbProperties telNbProperties;

    public DownStreamServiceImpl(RestTemplate restTemplate, ObjectMapper objectMapper, HeaderProvider headerProvider, TelNbProperties telNbProperties) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.headerProvider = headerProvider;
        this.telNbProperties = telNbProperties;
    }

    @Override
    public AbstractResponse createDeviceCmd(CreateDeviceCmdRequestDTO createDeviceCmd) throws JsonProcessingException {
        String value = this.objectMapper.writeValueAsString((Object)createDeviceCmd);
        HttpEntity entity = new HttpEntity((Object)value, (MultiValueMap)this.headerProvider.getAppJsonHeader());
        ResponseEntity response = this.restTemplate.postForEntity("/iocm/app/cmd/v1.4.0/deviceCommands", (Object)entity, String.class, new Object[0]);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, CreateDeviceCmdResponseDTO.class);
    }

    @Override
    public AbstractResponse queryDeviceCmd(@NotNull String deviceId, Integer pageNo, Integer pageSize, String startTime, String endTime) {
        if (pageNo == null) {
            pageNo = 0;
        }
        if (pageSize == null) {
            pageSize = 1000;
        }
        HashMap<String, Object> uris = new HashMap<String, Object>(8);
        uris.put("appId", this.telNbProperties.getAppId());
        uris.put("deviceId", deviceId);
        uris.put("pageNo", pageNo);
        uris.put("pageSize", pageSize);
        uris.put("startTime", startTime);
        uris.put("endTime", endTime);
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headerProvider.getAppJsonHeader());
        ResponseEntity response = this.restTemplate.exchange("/iocm/app/cmd/v1.4.0/deviceCommands?pageNo={pageNo}&pageSize={pageSize}&deviceId={deviceId}&startTime={startTime}&endTime={endTime}&appId={appId}", HttpMethod.GET, entity, String.class, uris);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, QueryDeviceCmdResponseDTO.class);
    }
}

