/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.telnb.service.impl;

import com.vcarecity.telnb.api.AddDeviceBean;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.core.DataResponse;
import com.vcarecity.telnb.dto.RegisteredDeviceRequestDTO;
import com.vcarecity.telnb.dto.RegisteredDeviceResponseDTO;
import com.vcarecity.telnb.dto.UpdateDeviceInfoRequestDTO;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.service.DataCollectService;
import com.vcarecity.telnb.service.DeviceManagerService;
import com.vcarecity.telnb.service.NbDeviceApiService;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"tel.nb.enable"})
public class NbDeviceApiServiceImpl
implements NbDeviceApiService {
    private final DeviceManagerService deviceManagerService;
    private final DataCollectService dataCollectService;
    private final TelNbProperties telNbProperties;

    public NbDeviceApiServiceImpl(DeviceManagerService deviceManagerService, DataCollectService dataCollectService, TelNbProperties telNbProperties) {
        this.deviceManagerService = deviceManagerService;
        this.dataCollectService = dataCollectService;
        this.telNbProperties = telNbProperties;
    }

    @Override
    public AbstractResponse addDevice(AddDeviceBean device) throws Exception {
        RegisteredDeviceRequestDTO reg = new RegisteredDeviceRequestDTO();
        reg.setNodeId(device.getImei());
        reg.setVerifyCode(device.getImei());
        reg.setEndUserId(device.getImsi());
        reg.setSecure(device.getSecure());
        reg.setTimeout(device.getTimeout());
        reg.setPsk(device.getPsk());
        AbstractResponse regResponse = this.deviceManagerService.registeredDevice(reg);
        if (regResponse.getHttpCode() == HttpStatus.OK.value()) {
            DataResponse regResponseData = (DataResponse)regResponse;
            RegisteredDeviceResponseDTO data = (RegisteredDeviceResponseDTO)regResponseData.getData();
            String deviceId = data.getDeviceId();
            UpdateDeviceInfoRequestDTO updateInfo = new UpdateDeviceInfoRequestDTO();
            if (device.getUnitNo() == null || device.getUnitNo().length() == 0) {
                updateInfo.setName(device.getImei());
            } else {
                updateInfo.setName(device.getUnitNo());
            }
            updateInfo.setManufacturerName(this.telNbProperties.getManufacturerName());
            updateInfo.setManufacturerId(this.telNbProperties.getManufacturerId());
            updateInfo.setDeviceType(this.telNbProperties.getDeviceType());
            updateInfo.setModel(this.telNbProperties.getModel());
            updateInfo.setProtocolType("CoAP");
            updateInfo.setRegion(device.getRegion());
            updateInfo.setTimezone(device.getTimezone());
            updateInfo.setOrganization(device.getOrganization());
            updateInfo.setSecure(device.getSecure());
            AbstractResponse updateResponse = this.deviceManagerService.updateDeviceInfo(deviceId, updateInfo);
            if (updateResponse.getHttpCode() == HttpStatus.NO_CONTENT.value()) {
                return updateResponse;
            }
            return this.deviceManagerService.deleteDevice(deviceId, "");
        }
        return regResponse;
    }

    @Override
    public AbstractResponse deleteDeviceById(@NotNull String deviceId) {
        return this.deviceManagerService.deleteDevice(deviceId, "");
    }

    @Override
    public AbstractResponse queryDeviceInfo(@NotNull String deviceId) {
        return this.dataCollectService.queryDeviceInfo(deviceId);
    }
}

