/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.telnb.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.telnb.context.IResponseDataContext;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.SubscribeBatchQueryResponseDTO;
import com.vcarecity.telnb.dto.SubscribeRequestDTO;
import com.vcarecity.telnb.dto.SubscribeResponseDTO;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.provider.HeaderProvider;
import com.vcarecity.telnb.service.SubscribeManagerService;
import com.vcarecity.telnb.util.ResponseHandleUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnProperty(value={"tel.nb.enable"})
public class SubscribeManagerServiceImpl
implements SubscribeManagerService {
    private final RestTemplate restTemplate;
    private final HeaderProvider headerProvider;
    private final ObjectMapper objectMapper;
    private final TelNbProperties telNbProperties;

    public SubscribeManagerServiceImpl(RestTemplate restTemplate, HeaderProvider headerProvider, ObjectMapper objectMapper, TelNbProperties telNbProperties) {
        this.restTemplate = restTemplate;
        this.headerProvider = headerProvider;
        this.objectMapper = objectMapper;
        this.telNbProperties = telNbProperties;
    }

    @Override
    public AbstractResponse subscribePlatformBusinessData(SubscribeRequestDTO subscribe, String ownerFlag) throws Exception {
        String value = this.objectMapper.writeValueAsString((Object)subscribe);
        HttpEntity entity = new HttpEntity((Object)value, (MultiValueMap)this.headerProvider.getAppJsonHeader());
        Map<String, String> map = Collections.singletonMap("ownerFlag", ownerFlag);
        ResponseEntity response = this.restTemplate.postForEntity("/iocm/app/sub/v1.2.0/subscriptions?ownerFlag={ownerFlag}", (Object)entity, String.class, map);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, SubscribeResponseDTO.class);
    }

    @Override
    public AbstractResponse deleteSubscribe(String subscriptionId) {
        HashMap<String, String> uri = new HashMap<String, String>(4);
        uri.put("appId", this.telNbProperties.getAppId());
        uri.put("subscriptionId", subscriptionId);
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headerProvider.getHttpHeaders());
        ResponseEntity response = this.restTemplate.exchange("/iocm/app/sub/v1.2.0/subscriptions/{subscriptionId}?appId={appId}", HttpMethod.DELETE, entity, String.class, uri);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, IResponseDataContext.class);
    }

    @Override
    public AbstractResponse batchQuerySubscribe(SubscribeRequestDTO.NotifyType notifyType, Integer pageNo, Integer pageSize) {
        HashMap<String, Object> uri = new HashMap<String, Object>(4);
        uri.put("appId", this.telNbProperties.getAppId());
        if (notifyType != null) {
            uri.put("notifyType", notifyType.getName());
        } else {
            uri.put("notifyType", "");
        }
        uri.put("pageNo", pageNo);
        uri.put("pageSize", pageSize);
        HttpEntity entity = new HttpEntity((MultiValueMap)this.headerProvider.getHttpHeaders());
        ResponseEntity response = this.restTemplate.exchange("/iocm/app/sub/v1.2.0/subscriptions?appId={appId}&notifyType={notifyType}&pageNo={pageNo}&pageSize={pageSize}", HttpMethod.GET, entity, String.class, uri);
        return ResponseHandleUtil.responseDataHandler((ResponseEntity<String>)response, SubscribeBatchQueryResponseDTO.class);
    }
}

