/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.telnb.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.telnb.core.CacheTemplate;
import com.vcarecity.telnb.entity.TokenEntity;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.service.AuthService;
import com.vcarecity.telnb.service.TokenService;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"tel.nb.enable"})
public class TokenServiceImpl
implements TokenService {
    private static final Logger logger = LoggerFactory.getLogger(TokenServiceImpl.class);
    private final AuthService authService;
    private final CacheTemplate cacheTemplate;
    private final ObjectMapper objectMapper;
    private final TelNbProperties telNbProperties;

    public TokenServiceImpl(AuthService authService, CacheTemplate cacheTemplate, ObjectMapper objectMapper, TelNbProperties telNbProperties) {
        this.authService = authService;
        this.cacheTemplate = cacheTemplate;
        this.objectMapper = objectMapper;
        this.telNbProperties = telNbProperties;
    }

    @Override
    @Nullable
    public String getAccessToken() {
        String baseKey = this.telNbProperties.getKeySpace();
        String tokenKey = baseKey + ":token:access_token";
        String accessToken = this.cacheTemplate.get(tokenKey);
        if (accessToken != null) {
            return accessToken;
        }
        String refreshTokenKey = baseKey + ":token:refresh_token";
        String refreshToken = this.cacheTemplate.get(refreshTokenKey);
        ResponseEntity<String> stringResponseEntity = this.authService.refreshToken(this.telNbProperties.getAppId(), this.telNbProperties.getSecret(), refreshToken);
        return this.accessTokenHandler(stringResponseEntity);
    }

    @Override
    @Nullable
    public String getRefreshToken() {
        String refreshTokenKey = this.telNbProperties.getKeySpace() + ":token:refresh_token";
        return this.cacheTemplate.get(refreshTokenKey);
    }

    @Override
    public String refreshAccessToken() {
        String refreshToken = this.getRefreshToken();
        if (refreshToken == null) {
            return this.getAccessToken();
        }
        ResponseEntity<String> stringResponseEntity = this.authService.refreshToken(this.telNbProperties.getAppId(), this.telNbProperties.getSecret(), refreshToken);
        return this.accessTokenHandler(stringResponseEntity);
    }

    @Override
    @NotNull
    public Long getRefreshTokenExpiresSecond() {
        Long expire = this.cacheTemplate.getExpire(this.telNbProperties.getKeySpace() + ":token:refresh_token");
        if (expire == null) {
            return -1L;
        }
        return expire;
    }

    @Override
    @NotNull
    public Long getAccessTokenExpiresSecond() {
        Long expire = this.cacheTemplate.getExpire(this.telNbProperties.getKeySpace() + ":token:access_token");
        if (expire == null) {
            return -1L;
        }
        return expire;
    }

    @Override
    public Long getTokenLastUpdateTime() {
        String s = this.cacheTemplate.get(this.telNbProperties.getKeySpace() + ":token:last_time");
        if (s != null) {
            return Long.parseLong(s);
        }
        return 0L;
    }

    @Override
    public void updateTokenLastTime() {
        String key = this.telNbProperties.getKeySpace() + ":token:last_time";
        this.cacheTemplate.set(key, String.valueOf(System.currentTimeMillis()), this.telNbProperties.getRefreshTokenExpire().longValue());
    }

    @Override
    public String getScope() {
        return this.cacheTemplate.get(this.telNbProperties.getKeySpace() + ":token:scope");
    }

    @Override
    public String getTokenType() {
        return this.cacheTemplate.get(this.telNbProperties.getKeySpace() + ":token:token_type");
    }

    private String accessTokenHandler(ResponseEntity<String> stringResponseEntity) {
        String baseKey = this.telNbProperties.getKeySpace();
        if (stringResponseEntity == null) {
            return null;
        }
        if (stringResponseEntity.getStatusCode() == HttpStatus.OK) {
            TokenEntity tokenEntity;
            try {
                tokenEntity = (TokenEntity)this.objectMapper.readValue((String)stringResponseEntity.getBody(), TokenEntity.class);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
                return null;
            }
            logger.debug("request access token = {}", (Object)tokenEntity.getAccessToken());
            int expiresIn = tokenEntity.getExpiresIn();
            this.cacheTemplate.set(baseKey + ":token:access_token", tokenEntity.getAccessToken(), Long.valueOf(expiresIn));
            this.cacheTemplate.set(baseKey + ":token:refresh_token", tokenEntity.getRefreshToken(), (long)this.telNbProperties.getRefreshTokenExpire());
            this.cacheTemplate.set(baseKey + ":token:scope", tokenEntity.getScope(), Long.valueOf(expiresIn));
            this.cacheTemplate.set(baseKey + ":token:token_type", tokenEntity.getTokenType(), Long.valueOf(expiresIn));
            this.cacheTemplate.set(baseKey + ":token:last_time", String.valueOf(System.currentTimeMillis()), (long)this.telNbProperties.getRefreshTokenExpire());
            return tokenEntity.getAccessToken();
        }
        if (stringResponseEntity.getStatusCode() == HttpStatus.UNAUTHORIZED) {
            logger.error("401.UNAUTHORIZED. {}", stringResponseEntity.getBody());
        }
        return null;
    }
}

